// version 20201105

var MAX_LINEA = 10;
var MAX_LIN_IMP = 18;
var CANT_DET_BEGIN = 3;
var CARCATERTES_X_LINEA = 45;
var RegExpFinLinea = /\n/gi;
var RegExpEscape = /\~\^/gi;
var queryString = "mipeGenFacEx.cgi?";

window.onerror = reportJSError;
function reportJSError(errorMessage,url,lineNumber)
{
	/* form payload string with error data */
	payload = "url="+url;
	payload += "message=" + errorMessage;
	payload += "&line=" + lineNumber;
	/* submit error message */
	//var img = new Image( );
	// img.src = "http://example.com/errormonitor.php"+"?error=scriptruntime&"+payload;
	alert("JavaScript Error : "+payload);
	/* return true to suppress normal JS errors */
	return true;
}


function borrarTab(n){
	noPermitidos= /\t/g;
	if(noPermitidos.test(n.value)){
		n.focus();
		alert("Evite copiar caracteres especiales ya que producen problemas posteriores en la emisión.");
	}
}

function despiegaDatos(obj) {
	var f = obj.form;
	var i=0;
	while(!isNull(f.elements[i])) {
		alert(f.elements[i].name +'='+ f.elements[i].value);
		i++;
	}
}

function verLargoPalabra(param) {

	var str = new String(param);
	var posIni = 0;
	var posFin = 0;
	var posFinFinLinea = 0;
	var posFinEspacio = 0;
	var MAX_L_WORD = 30;

	while ((str.indexOf(' ',posIni) != -1) || (str.indexOf('\n',posIni) != -1)) {
		posFinEspacio = str.indexOf(' ',posIni);
		posFinFinLinea = str.indexOf('\n',posIni);

		if ((posFinEspacio != -1) && (posFinFinLinea != -1)) {
			posFin = ((posFinFinLinea>posFinEspacio)?posFinEspacio:posFinFinLinea);
		}
		else {
			posFin = ((posFinFinLinea==-1)?posFinEspacio:posFinFinLinea);
		}

		if ((posFin - posIni) > MAX_L_WORD) {
			return(str.slice(posIni, posFin));
		}
		posIni = posFin +1;
	}

	posFin = str.length;
	if ((posFin - posIni) > MAX_L_WORD) return(str.slice(posIni, posFin));

	return("");
}

function validaLinDet(f, numLinea) { // f es puntero a formulario

	var eMsg = "";
	var tpoCodName = "EFXP_TPO_COD_"+numLinea;
	var codName = "EFXP_COD_"+numLinea;
	var precioName = "EFXP_PRC_"+numLinea;
	var descName = "EFXP_PCTD_"+numLinea;
	var descripName = "EFXP_DSC_ITEM_"+numLinea;
	var tpoCod= "";
	var cod= "";
	var nom  = trimval(f.elements["EFXP_NMB_"+numLinea].value);
	var cant = f.elements["EFXP_QTY_"+numLinea].value;
	var uMed = f.elements["EFXP_UNMD_"+numLinea].value;
	var precio = f.elements[precioName].value;
	var desc = f.elements[descName].value;
	var descrip = '';
	var palabraLarga;
	var muchosBlancos='                                                                                                                                                                          ';
	
	var impuestoAdicional="";
	if(f.elements["OTRO_IMP_SI_NO"]!= null && f.elements["OTRO_IMP_SI_NO"].checked == true)
		impuestoAdicional= f.elements["EFXP_OTRO_IMP_"+numLinea].value;
	else
		impuestoAdicional="";
	
		
	if(desc>0){		
		var montoPorcentaje = (desc/100);		
			
			if(montoPorcentaje==1)
				montoImp=precio-precio;
			else
				montoImp=montoPorcentaje*precio;
		 
		if( parseInt(montoImp)==0 && impuestoAdicional!=""){
			eMsg += "En linea "+numLinea+" el porcentaje de descuento ["+f.elements[descName].value+"] es muy alto en relación al precio ["+f.elements[precioName].value+"] ingresado, por lo cual debe quitar el Impuesto Adicional seleccionado\n";
			f.elements["EFXP_PCTD_"+numLinea].focus();
		}
	}

	if (f.elements[codName] != null) {
		tpoCod = f.elements[tpoCodName].value;
		cod = f.elements[codName].value;
	}

	if  (f.elements[descripName] != null) descrip = f.elements[descripName].value;

	var strLinea;
	if (numLinea == 1) strLinea = 'primera';
	else if (numLinea == 2 ) strLinea = 'segunda';
	else if (numLinea == 3 ) strLinea = 'tercera';
	else if (numLinea == 4 ) strLinea = 'cuarta';
	else if (numLinea == 5 ) strLinea = 'quinta';
	else if (numLinea == 6 ) StrLinea = 'secta';
	else if (numLinea == 7 ) strLinea = 'septima';
	else if (numLinea == 8 ) strLinea = 'octava';
	else if (numLinea == 9 ) strLinea = 'novena';
	else if (numLinea == 10) strLinea = 'decima';

	if ((tpoCod.length > 0) || (cod.length > 0) || (nom.length > 0) || (cant != 0) || (precio != 0) || (desc != 0) || (descrip.length > 0) ||
			impuestoAdicional!="") {

		if ((nom.length > 0) && (cant != 0) && (precio != 0)) {

			if ((parseFloat(cant) == NaN) || (cant < 1)) eMsg += "La cantidad de unidades indicada en la "+strLinea+" línea del detalle está en blanco y debe ser mayor a 0.\n";

			if (((tpoCod.length > 0) && (cod.length == 0)) || ((cod.length > 0) && (tpoCod.length == 0))) eMsg += "Si ingresa codigo o tipo de codigo en la "+strLinea+" línea del detalle tambien debe ingresar el otro valor.\n";

			if ((parseFloat(precio) == NaN) || (precio < 0)) eMsg += "El precio del producto indicado en la "+strLinea+" línea del detalle está en blanco y debe ser mayor a 0.\n";

			if ((noEsPorcentaje(desc) == true) && (desc.length > 0)) eMsg += "Descuento linea "+strLinea+" debe ser un porcentaje mayor que 0 y menor o igual que 100\n";

			if (descrip.length >= 1000) 
				eMsg += "Descripcion extendida del producto o servicio de linea "+numLinea+" no puede tener mas de 1000 caracteres\n";
			if (descrip.length > 100 && descrip.indexOf(muchosBlancos)!=-1) 
				eMsg += "La descripción extendida del producto con muchos espacios en blanco, modifica la visualización del documento, favor modificarlo.\n";

			palabraLarga = verLargoPalabra(descrip);
			if (palabraLarga.length > 0 ) eMsg += "Descripcion extendida del producto o servicio de linea "+numLinea+" no puede tener palabras tan grandes como '"+palabraLarga+"'.\n";
		}
		else {
			eMsg = "Debe completar la línea "+numLinea+" del detalle o quitar esa línea.\n";
		}
	}
	
	
	return eMsg;
}

function valRutSolicita(obj) {

	var f = obj.form;

	if (obj.value == 'k') obj.value = 'K';

	if ((f.elements["EFXP_RUT_SOLICITA"].value.length > 0) || (f.elements["EFXP_DV_SOLICITA"].value.length > 0)) {
		if (validaRDP(trimval(f.elements["EFXP_RUT_SOLICITA"].value) + "-" + f.elements["EFXP_DV_SOLICITA"].value) == false) {
				Msg = "Rut solicitante incorrecto\n";
				alert(Msg);
				f.elements["EFXP_RUT_SOLICITA"].focus();
				return;
		}
	}
}

function enviaCGI(obj) {

	if(document.forms["VIEW_EFXP"].elements["PTDC_CODIGO"].value==110||
		document.forms["VIEW_EFXP"].elements["PTDC_CODIGO"].value==111||
		document.forms["VIEW_EFXP"].elements["PTDC_CODIGO"].value==112) {
			return;
	}
	var f = obj.form;
	var i = 0;
	var primero = true;
	var Msg;

	if (obj.value == 'k') obj.value = 'K';

	if ((f.elements["EFXP_RUT_RECEP"].value.length > 0) || (f.elements["EFXP_DV_RECEP"].value.length > 0)) {
		if (validaRDP(trimval(f.elements["EFXP_RUT_RECEP"].value) + "-" + f.elements["EFXP_DV_RECEP"].value) == false) {
			Msg = "Rut Receptor incorrecto\n";
			alert(Msg);
			f.elements["EFXP_RUT_RECEP"].focus();
			return;
		}
		else		
			$("#ocultaGifWait").html("<img src='/Portal001/wait.gif' width='30' height='30'>");
	}

	var i;
	var linea;
	var dscItemName = "EFXP_DSC_ITEM_";

	for(i = 1; i <= MAX_LINEA; i++) {
		if (i < MAX_LINEA) linea = '0'+i;
		else linea = i;

		if (f.elements[dscItemName+linea] != null) {
			var dscItem = new String(f.elements[dscItemName+linea].value);
			if (dscItem.length > 0) {
					var dscItem2 = dscItem.replace(RegExpFinLinea,'~^');
					f.elements[dscItemName+linea].value = dscItem2;
			}
		}
	}

	f.action = queryString;
	f.submit();
}

function validaPagos() {
  var f = document.forms["VIEW_EFXP"];
  var i;
  var fchPago = 'EFXP_FCH_PAGO_00';
  var mntPago = 'EFXP_MNT_PAGO_00';
  var glsPago = 'EFXP_GLOSA_PAGOS_00';
  var errMsg= '';
  var fila = '';
  var total = 0;
  var fchTemp = f.elements["EFXP_FCH_EMIS"].value;

	if (f.elements["PAGO_SI_NO"].checked == true) {

		if ((sinInfo(f.elements[mntPago+'1'].value) == true) || ((isNaN(Number(f.elements[mntPago+1].value)) == true))) {
				errMsg += 'Si pone información de Pagos, el primer pago es obligatorio y debe ser numerico\n';
		}

		for (i=1; i <=3 ; i++) {
			if (i == 1) fila = 'primer pago';
			else if (i == 2) fila = 'segundo pago';
			else if (i == 3) fila = 'tercer pago';
			if ((sinInfo(f.elements[mntPago+i].value) == true) && (sinInfo(f.elements[glsPago+i].value) == false))
				errMsg += 'Debe ingresar monto de pago si es que ingreso glosa en '+fila+'.\n';

			if ((sinInfo(f.elements[mntPago+i].value) == false) &&( (isNaN(Number(f.elements[mntPago+i].value)) == true) ||(Number(f.elements[mntPago+i].value) <= 0)))
				errMsg += 'Monto debe ser numerico y mayor a 0 en el '+fila+'.\n';

			if ((sinInfo(f.elements[mntPago+i].value) == true) && (sinInfo(f.elements[glsPago+i].value) == true)) {
					f.elements[fchPago+i].value = '';
			}
			else {
				actulizaFecha(f.elements['cbo_dia_boleta_pago_0'+i]);
				if (validaStrFechaYYYYMMDD(f.elements[fchPago+i].value) == false) {
					errMsg += 'Fecha ingresada en el '+fila+' es incorrecta.\n';
				}
				else {
					if ((i==1) && (f.elements[fchPago+i].value < fchTemp)) {
							errMsg += 'La fecha del primer pago debe ser mayor o igual a la fecha de emision del documento\n';
					} else if ((i!=1) &&(f.elements[fchPago+i].value <= fchTemp)) {
							errMsg += 'La fecha del '+ fila +' debe ser mayor a la fecha del pago anterior\n';
					}
					fchTemp = f.elements[fchPago+i].value;
				}
			}
			if (isNaN(Number(f.elements[mntPago+i].value)) == false) total += Number(f.elements[mntPago+i].value);
		}
		if (total != f.elements["EFXP_MNT_TOTAL"].value)
				errMsg += 'La suma de los pagos parciales ['+total+'] debe ser igual al total de la factura ['+f.elements["EFXP_MNT_TOTAL"].value+']\n';
	}

	return errMsg;
}

function validaRefNumerico(tpoDoc, valorFolio) {
  var arrDocFolNum = ['30','32','38','40','45','50','55','60','33','34','39','46','56','61','52','103','fin'];
  var i;
  var bDocValido = false;

	for (i = 0; arrDocFolNum[i] != 'fin'; i++) {
		if (tpoDoc == parseInt(arrDocFolNum[i],10)) {
				bDocValido = true;
				break;
		}
	}
	if (bDocValido == true) return isNumero(valorFolio) && (valorFolio > 0);

	return true;
}

function validaRefernecias() {
  var f = document.forms["VIEW_EFXP"];
  var i, j;
  var errMsg= '';

	var tipoDoc=f.elements["PTDC_CODIGO"].value;
	var arrDocValidos = getArrTipoDocRef();
	
	
  var bDocValido = false;
  var fila = '';
  var tpo_doc = 'EFXP_TPO_DOC_REF_00';
  var ind_glb = 'EFXP_IND_GLOBAL_00';
  var folio   = 'EFXP_FOLIO_REF_00';
  var fecha   = 'EFXP_FCH_REF_00';
  var actFecha = 'cbo_dia_boleta_ref_0';
  var razon   = 'EFXP_RAZON_REF_00';

	if (f.elements["REF_SI_NO"].checked == true) {
		for (i=1; i <=3 ; i++) {
			if (i==1) {// Primer elemento tiene que estar los campos oblilgatorios
				if (sinInfo(f.elements[tpo_doc+i].value)) {
					errMsg += 'Si pone referencias, Doc. (Tipo Documento de Referencia) es obligatorio\n';
				}
				else if (isNumero(f.elements[tpo_doc+i].value)) {
					for (j = 0; arrDocValidos[j] != 'fin'; j++) {
						if (f.elements[tpo_doc+i].value == arrDocValidos[j]) {
								bDocValido = true;
								break;
						}
					}
					if (bDocValido == false) {
						errMsg += 'Si Doc. (Tipo Documento de Referencia) es numerico este tiene que tener alguno de los sigientes valores ';
						for (j = 0; arrDocValidos[j] != 'fin'; j++) {
							if (j == 0)
									errMsg += arrDocValidos[j];
							else
									errMsg += ', '+arrDocValidos[j];
						}
						if (arrDocValidos[j] == 'fin') errMsg += '\n';
					}
				}

				if ((validaRefNumerico(f.elements[tpo_doc+i].value, f.elements[folio+i].value) == false ) &&(f.elements[ind_glb+i].value != '1'))
						errMsg += 'El tipo de documento selecionado en la referencia exige que Folio Ref. sea numerico y mayor a 0\n';

				if ((sinInfo(f.elements[ind_glb+i].value) == false) && (f.elements[ind_glb+i].value != 1))
						errMsg += 'Si ingresa Ind.(Indicador de Referencia Global) esto solo puede tener valor 1\n';

				if (sinInfo(f.elements[folio+i].value))
						errMsg += 'Si pone referencias, el Folio Ref. del documento referenciado es obligatorio\n';

				if ((f.elements[ind_glb+i].value == '1') && (f.elements[folio+i].value != 0))
						errMsg += 'Si ingresa Ind.(Indicador de Referencia Global), Folio Ref. tiene que tener valor 0';

				actulizaFecha(f.elements[actFecha+i]);
				if (validaStrFechaYYYYMMDD_inclusive(f.elements[fecha+i].value,"2002-08-01", "2050-12-31") == false)
						errMsg += 'Si ingresa Fecha Ref., esta debe ser valida ademas de  estar entre "2002-08-01" y "2050-12-31"\n';
			}
			else { // i > 1
				if (i == 2) fila = 'segunda';
				if (i == 3) fila = 'tercera';
				if ((sinInfo(f.elements[tpo_doc+i].value) == false) ||(sinInfo(f.elements[ind_glb+i].value) == false) ||
						 (sinInfo(f.elements[folio+i].value) == false) ||(sinInfo(f.elements[razon+i].value) == false)) {

					if (sinInfo(f.elements[tpo_doc+i].value))
						errMsg += 'Si pone referencias en la '+fila+' fila, Doc. (Tipo Documento de Referencia) es obligatorio\n';
					else if (isNumero(f.elements[tpo_doc+i].value)) {
						for (j = 0; arrDocValidos[j] != 'fin'; j++) {
							if (f.elements[tpo_doc+i].value == arrDocValidos[j]) {
									bDocValido = true;
									break;
							}
						}

						if (bDocValido == false) {
							errMsg += 'Si Doc. (Tipo Documento de Referencia) en la '+fila+' fila es numerico, este tiene que tener alguno de los sigientes valores ';
							for (j = 0; arrDocValidos[j] != 'fin'; j++) {
								if (j == 0)
										errMsg += arrDocValidos[j];
								else
										errMsg += ', '+arrDocValidos[j];
							}
							if (arrDocValidos[j] == 'fin') errMsg += '\n';
						}
					}

					if ((validaRefNumerico(f.elements[tpo_doc+i].value, f.elements[folio+i].value) == false )&&(f.elements[ind_glb+i].value != '1'))
							errMsg += 'El tipo de documento selecionado en la '+fila+' fila, exige que Folio Ref. sea numerico y mayor a 0\n';

					if ((sinInfo(f.elements[ind_glb+i].value) == false) && (f.elements[ind_glb+i].value != 1))
							errMsg += 'Si ingresa datos en la '+fila+' fila,Ind.(Indicador de Referencia Global) solo puede tener valor 1\n';

					if (sinInfo(f.elements[folio+i].value))
							errMsg += 'Si ingresa datos en la '+fila+' fila, Folio Ref. del documento referenciado es obligatorio\n';

					if ((f.elements[ind_glb+i].value == '1') && (f.elements[folio+i].value != 0))
							errMsg += 'Si ingresa datos en la '+fila+' fila y seteo Ind.(Indicador de Referencia Global), Folio Ref. tiene que tener valor 0';

					actulizaFecha(f.elements[actFecha+i]);
					if (validaStrFechaYYYYMMDD_inclusive(f.elements[fecha+i].value,"2002-08-01", "2050-12-31") == false)
						errMsg += 'Si ingresa datos en la '+fila+' fila, Fecha Ref. debe ser valida ademas de estar entre "2002-08-01" y "2050-12-31"\n';
				}
				else {
						f.elements[fecha+i].value = '';
				}
			}
		}
	}
	return errMsg;
}


function validaEmail(email) {
    var re = /^(([^<>()\[\]\\.,;:\s@"]+(\.[^<>()\[\]\\.,;:\s@"]+)*)|(".+"))@((\[[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\])|(([a-zA-Z\-0-9]+\.)+[a-zA-Z]{2,}))$/;
    return re.test(String(email).toLowerCase());
}


function validaFacEx(obj) {
	var f = obj.form;
	var errMsg = "";
	var errMsgTemp = "";
	var msgTemp = null;
	var elemento = null;

	if (sinInfo(f.elements["EFXP_RZN_SOC"].value) == true) {
		errMsg += "Debe ingresar Razon Social del contribuyente emisor\n";
		if (elemento == null) elemento = f.elements["EFXP_RZN_SOC"];
	}
	if (sinInfo(f.elements["EFXP_GIRO_EMIS"].value) == true) {
		errMsg += "Debe ingresar Giro del contribuyente emisor\n";
		if (elemento == null) elemento = f.elements["EFXP_GIRO_EMIS"];
	}
	
	//alert(f.elements["EFXP_ACTECO"].value);
	
	if ((isNumero(f.elements["EFXP_ACTECO"].value) == false) || (f.elements["EFXP_ACTECO"].value.length == 0))  {
		errMsg += "Debe ingresar Codigo de Actividad Economica del emisor (valor numerico)\n";
		if (elemento == null) elemento = f.elements["EFXP_ACTECO"];
	}
	if (sinInfo(f.elements["EFXP_DIR_ORIGEN"].value) == true) {
		errMsg += "Debe ingresar Direccion del contribuyente emisor\n";
		if (elemento == null) elemento = f.elements["EFXP_DIR_ORIGEN"];
	}
	if (sinInfo(f.elements["EFXP_CMNA_ORIGEN"].value) == true) {
		errMsg += "Debe ingresar Comuna del contribuyente emisor\n";
		if (elemento == null) elemento = f.elements["EFXP_CMNA_ORIGEN"];
	}
	if (sinInfo(f.elements["EFXP_CIUDAD_ORIGEN"].value) == true) {
		errMsg += "Debe ingresar Ciudad del contribuyente emisor\n";
		if (elemento == null) elemento = f.elements["EFXP_CIUDAD_ORIGEN"];
	}
	
	
	
	if (sinInfo(f.elements["EFXP_EMAIL_EMISOR"].value) == false && validaEmail(f.elements["EFXP_EMAIL_EMISOR"].value)==false) {
		errMsg += "Error en formato de Email emisor. Ejemplo: ejemplo@sii.cl\n";
		if (elemento == null) elemento = f.elements["EFXP_EMAIL_EMISOR"];
	}
	
	if (sinInfo(f.elements["EFXP_FONO_EMISOR"].value) == false && isNumero(f.elements["EFXP_FONO_EMISOR"].value.replace(/ /g,""))==false) {
		errMsg += "Error en formato de teléfono emisor. Solo caracteres numéricos y espacios\n";
		if (elemento == null) elemento = f.elements["EFXP_FONO_EMISOR"];
	}

	
	
	if ((f.elements["PTDC_CODIGO"].value == 33) || (f.elements["PTDC_CODIGO"].value == 34))
	{
		if(f.elements["EFXP_TIPOVENTA_SELECT"]!= null && f.elements["EFXP_TIPOVENTA_SELECT"].value==0)
		{
			errMsg += "Debe Seleccionar Tipo de Venta en Emisor\n";
			if (elemento == null) elemento = f.elements["EFXP_TIPOVENTA_SELECT"];
		}
	}
	
	if (f.elements["EFXP_RUT_SOLICITA"]!=null&&((f.elements["EFXP_RUT_SOLICITA"].value.length > 0) || (f.elements["EFXP_DV_SOLICITA"].value.length > 0))) {
		if (f.elements["EFXP_DV_SOLICITA"].value == 'k') f.elements["EFXP_DV_SOLICITA"].value = 'K';
		if (validaRDP(trimval(f.elements["EFXP_RUT_SOLICITA"].value) +
													"-" + f.elements["EFXP_DV_SOLICITA"].value) == false) {
				errMsg += "Rut solicitante incorrecto\n";
				if (elemento == null) elemento = f.elements["EFXP_RUT_SOLICITA"];
		}
	}
	
	if (f.elements["cbo_dia_boleta"]!=null)
		actulizaFecha(f.elements["cbo_dia_boleta"]);

	if (validaStrFechaYYYYMMDD(f.elements["EFXP_FCH_EMIS"].value) == false) {
		errMsg += "Fecha ingresada  incorrecta\n";
		if (elemento == null) elemento = f.elements["cbo_dia_boleta"];
	} else {
		if ((msgTemp = valRangoValido(f.elements["EFXP_FCH_EMIS"].value, arrFecha[0], arrFecha[1], arrFecha[2])) != null) {
			if (elemento == null) elemento = f.elements["cbo_dia_boleta"];
			errMsg += msgTemp;
		}
		else if ((f.elements["EFXP_FCH_EMIS"].value) < (arrFechaAut[0]+"-"+arrFechaAut[1]+"-"+arrFechaAut[2])) {
			errMsg += "No puede ingresar fecha de emison anterior a la fecha de autorizacion del documento: "+arrFechaAut[2]+"-"+arrFechaAut[1]+"-"+arrFechaAut[0]+"\n";
			if (elemento == null) elemento = f.elements["cbo_dia_boleta"];
		}
	}
	
		if(document.forms["VIEW_EFXP"].elements["PTDC_CODIGO"].value!=110&&
		 document.forms["VIEW_EFXP"].elements["PTDC_CODIGO"].value!=111&&
		 document.forms["VIEW_EFXP"].elements["PTDC_CODIGO"].value!=112) {

		if ( ((sinInfo(f.elements["EFXP_RUT_RECEP"].value) == true)  || (sinInfo(f.elements["EFXP_DV_RECEP"].value) == true))
		 || (validaRDP(trimval(f.elements["EFXP_RUT_RECEP"].value) + "-" + f.elements["EFXP_DV_RECEP"].value) == false)) {
			errMsg += "Debe ingresar un rut Receptor correcto\n";
			if (elemento == null) elemento = f.elements["EFXP_RUT_RECEP"];
		}

		if (f.elements["EFXP_GIRO_RECEP"]!=null&&sinInfo(f.elements["EFXP_GIRO_RECEP"].value) == true) {
			errMsg += "Debe ingresar Giro del contribuyente receptor\n";
			if (elemento == null) elemento = f.elements["EFXP_GIRO_RECEP"];
		}
		if (f.elements["EFXP_DIR_RECEP"]!=null&&sinInfo(f.elements["EFXP_DIR_RECEP"].value) == true) {
			errMsg += "Debe ingresar Direccion del contribuyente receptor\n";
			if (elemento == null) elemento = f.elements["EFXP_DIR_RECEP"];
		}
		if (f.elements["EFXP_CIUDAD_RECEP"]!=null&&sinInfo(f.elements["EFXP_CIUDAD_RECEP"].value) == true) {
			errMsg += "Debe ingresar Ciudad del contribuyente receptor\n";
			if (elemento == null) elemento = f.elements["EFXP_CIUDAD_RECEP"];
			if (elemento == null) elemento = f.elements["EFXP_CIUDAD_RECEP"];
		}
		if (f.elements["EFXP_CMNA_RECEP"]!=null&&sinInfo(f.elements["EFXP_CMNA_RECEP"].value) == true) {
			errMsg += "Debe ingresar Comuna del contribuyente receptor\n";
			if (elemento == null) elemento = f.elements["EFXP_CMNA_RECEP"];
		}
	}

	esFACT_TUR=document.getElementById('esFACT_TUR');
	if (esFACT_TUR != null && esFACT_TUR.value == 'TRUE') {
	    if (f.elements["EFXP_CMNA_ORIGEN"]!=null && sinInfo(f.elements["EFXP_CMNA_ORIGEN"].value) != true) {
				if (f.elements["EFXP_CMNA_ORIGEN"].value.toUpperCase() != "ARICA"
         && f.elements["EFXP_CMNA_ORIGEN"].value.toUpperCase() != "CAMARONES"
         && f.elements["EFXP_CMNA_ORIGEN"].value.toUpperCase() != "PUTRE"
				 && f.elements["EFXP_CMNA_ORIGEN"].value.toUpperCase() != "GENERAL LAGOS") {
      		errMsg += "Debe ingresar una dirección perteneciente a:\n          Arica, Camarones, Putre ó General Lagos\n";
      		if (elemento == null) elemento = f.elements["EFXP_DIR_ORIGEN"];
				}
    }
	}

	if (f.elements["EFXP_RZN_SOC_RECEP"].value.length > 100) {
			errMsg += "Razon Social del receptor no debe tener más de 100 caracteres \n";
			if (elemento == null) elemento = f.elements["EFXP_RZN_SOC_RECEP"];
	}

	if (sinInfo(f.elements["EFXP_RZN_SOC_RECEP"].value) == true) {
		errMsg += "Debe ingresar Razon Social del contribuyente receptor\n";
		if (elemento == null) elemento = f.elements["EFXP_RZN_SOC_RECEP"];
	}
	
	if (esFACT_TUR != null && esFACT_TUR.value == 'TRUE') {
		if (sinInfo(f.elements["EFXP_NUM_ID"].value) == true) {
    	errMsg += "Debe ingresar N° de Documento del Turista\n";
    	if (elemento == null) elemento = f.elements["EFXP_NUM_ID"];
		}

	}

	if ((f.elements["PTDC_CODIGO"].value == 33) || (f.elements["PTDC_CODIGO"].value == 34))
	{
		if(f.elements["EFXP_TIPOCOMPRA_SELECT"]!=null && f.elements["EFXP_TIPOCOMPRA_SELECT"].value==0)
		{
			errMsg += "Debe Seleccionar Tipo de Compra en Receptor\n";
			if (elemento == null) elemento = f.elements["EFXP_TIPOCOMPRA_SELECT"];
		}
	}
	
	
	if (sinInfo(f.elements["EFXP_NMB_01"].value) == true) {
		errMsg += "Debe ingresar nombre del primer item del detalle\n";
		if (elemento == null) elemento = f.elements["EFXP_NMB_01"];
	}
	if (f.elements["EFXP_RAZON_REF_001"] != null&&f.elements["EFXP_RAZON_REF_001"].value.length > 90 ){
		errMsg += "Razón Referencia uno no debe tener más de 90 caracteres\n";
	}

	if (f.elements["EFXP_RAZON_REF_002"] != null&&f.elements["EFXP_RAZON_REF_002"].value.length > 90 ){
		errMsg += "Razón Referencia dos no debe tener más de 90 caracteres\n";
	}

	if (f.elements["EFXP_RAZON_REF_003"] != null&&f.elements["EFXP_RAZON_REF_003"].value.length > 90 ){
		errMsg += "Razón Referencia tres no debe tener más de 90 caracteres\n";
	}

	if ((parseFloat(f.elements["EFXP_QTY_01"].value) == NaN) ||(f.elements["EFXP_QTY_01"].value < 1)) {
		errMsg += "Cantidad de unidades del primer item del detalle debe ser mayor a 0\n";
		if (elemento == null) elemento = f.elements["EFXP_QTY_01"];
	}
	if ( (parseFloat(f.elements["EFXP_PRC_01"].value) == NaN) ||(f.elements["EFXP_PRC_01"].value < 0)) {
		errMsg += "Precio del primer item del detalle debe ser mayor a 0\n";
		if (elemento == null) elemento = f.elements["EFXP_PRC_01"];
	}

	errMsgTemp = validaRefernecias();
	if (errMsgTemp.length > 0) {
		errMsg += errMsgTemp;
		if (elemento == null) elemento = f.elements["EFXP_TPO_DOC_REF_001"];
	}
	errMsg += validaPagos();

	if ((noEsPorcentaje(f.elements["EFXP_PCTD_01"].value) == true) && (f.elements["EFXP_PCTD_01"].value.length > 0)) {
		errMsg += "Descuento linea 1 debe ser un porcentaje mayor que 0 y menor o igual que 100\n";
		if (elemento == null) elemento = f.elements["EFXP_PCTD_01"];
	}
	if ((noEsPorcentaje(f.elements["EFXP_PCT_DESC"].value) == true) && (f.elements["EFXP_PCT_DESC"].value != 0)) {
		errMsg += "Descuento total debe ser un porcentaje mayor o igual que 0 y menor o igual que 100\n";
		if (elemento == null) elemento = f.elements["EFXP_PCT_DESC"];
	}

	if ( (isNumero(f.elements["EFXP_MNT_TOTAL"].value) == false) || (f.elements["EFXP_MNT_TOTAL"].value < 1)) {
		errMsg += "Valor Total Factura debe ser mayor a 0\n";
		if (elemento == null) elemento = f.elements["EFXP_MNT_TOTAL"];
	}
	if (f.elements["PTDC_CODIGO"].value == 33) {
		if ( (isNumero(f.elements["EFXP_IVA"].value) == false) || (f.elements["EFXP_IVA"].value < 1)) {
			errMsg += "Valor IVA debe ser mayor a 0\n";
			if (elemento == null) elemento = f.elements["EFXP_IVA"];
		}

      if ((esFACT_TUR == null || esFACT_TUR.value != 'TRUE')
         && (f.elements["EFXP_CRED_EC"] == null)) {
		if (f.elements["UBIC_MADERA_SI_NO"].checked) {
			if (!isNumero(f.elements["EFXP_COMUNA_ROL_ORIGEN"].value)
					|| f.elements["EFXP_COMUNA_ROL_ORIGEN"].value <= 0
					|| f.elements["EFXP_COMUNA_ROL_ORIGEN"].value.length > 6) {
				errMsg += "Debe ingresar un código de Comuna Rol Predio Origen válido de hasta 6 dígitos\n";
				if (elemento == null) elemento = f.elements["EFXP_COMUNA_ROL_ORIGEN_SEL"];
			}

			if (!isNumero(f.elements["EFXP_MAN_ROL_ORIGEN"].value)
					|| f.elements["EFXP_MAN_ROL_ORIGEN"].value <= 0
					|| f.elements["EFXP_MAN_ROL_ORIGEN"].value.length > 6) {
				errMsg += "Debe ingresar un código de Manzana Rol Origen válido de hasta 6 dígitos\n";
				if (elemento == null) elemento = f.elements["EFXP_MAN_ROL_ORIGEN"];
			}

			if (!isNumero(f.elements["EFXP_PRED_ROL_ORIGEN"].value)
					|| f.elements["EFXP_PRED_ROL_ORIGEN"].value <= 0
					|| f.elements["EFXP_PRED_ROL_ORIGEN"].value.length > 6) {
				errMsg += "Debe ingresar un código de Predio Rol Origen válido de hasta 6 dígitos\n";
				if (elemento == null) elemento = f.elements["EFXP_PRED_ROL_ORIGEN"];
			}
	
			if (!isValidLatitud(f.elements["EFXP_LAT_ORIG_MADERA"].value)) {
				errMsg += "Debe ingresar una Latitud Origen Madera en grados decimales válida\n";
				if (elemento == null) elemento = f.elements["EFXP_LAT_ORIG_MADERA"];
			}
	
			if (!isValidLongitud(f.elements["EFXP_LONG_ORIG_MADERA"].value)) {
				errMsg += "Debe ingresar una Longitud Origen Madera en grados decimales válida\n";
				if (elemento == null) elemento = f.elements["EFXP_LONG_ORIG_MADERA"];
			}
	
			if (!isNumero(f.elements["EFXP_COD_PLAN_CONAF"].value)
					|| f.elements["EFXP_COD_PLAN_CONAF"].value <= 0
					|| f.elements["EFXP_COD_PLAN_CONAF"].value.length > 10) {
				errMsg += "Debe ingresar un código de Plan de Manejo CONAF válido de hasta 10 dígitos\n";
				if (elemento == null) elemento = f.elements["EFXP_COD_PLAN_CONAF"];
			}
		}
	  }
	}
	
	if ((f.elements["PTDC_CODIGO"].value == 33) || (f.elements["PTDC_CODIGO"].value == 34))
	{
		if(f.elements["EFXP_FMA_PAGO"]!= null && f.elements["EFXP_FMA_PAGO"].value==0)
		{
			errMsg += "Debe Seleccionar Forma de Pago\n";
			if (elemento == null) elemento = f.elements["EFXP_FMA_PAGO"];
		}
	}

	if (f.elements["EFXP_CRED_EC"]!=null&&f.elements["EFXP_CRED_EC"].value != 0) {
		var descCRED_EC = 0;
		var temp = Number(f.elements["EFXP_CRED_EC"].value);

		if (temp == NaN) {
			alert("Valor debe ser numérico.");
			f.elements["EFXP_CRED_EC"].focus();
			return;
		}
		else {
			// debe usar un acteco de empresa constructora
			if (f.elements["EFXP_ACTECO"].value!=null || f.elements["EFXP_ACTECO"].value!="") {
				var actecoSel = f.elements["EFXP_ACTECO"].value;
				if (actecoSel!=452010 && actecoSel!=452020 && actecoSel!=410010 && actecoSel!=421000) {
					alert("Si usa credito empresa constructora, debe seleccionar actividad economica relacionada.");
					f.elements["EFXP_ACTECO_SELECT"].focus();
					return;
				}
			}
			descCRED_EC = temp;

			var auxIva = 0;
			var f = f.elements["EFXP_CRED_EC"].form;
			temp = Number(f.elements["EFXP_IVA"].value);
			if (temp == NaN) {
				errMsg += "Valor debe ser numérico y no puede ser decimal.\n";
				if (elemento == null) elemento = f.elements["EFXP_IVA"];
			}
			else {
				auxIva = temp;
				temp = auxIva * (65/100);
				if (temp != NaN) {
						if(descCRED_EC>Math.round(temp)) {
							errMsg += "Valor debe ser menor o igual al 65% del IVA(" + Math.round(temp) + ").\n";
							if (elemento == null) elemento = f.elements["EFXP_CRED_EC"];
						}
				}
			}
		}
	}

  //Fac. Expo
  if(document.forms["VIEW_EFXP"].elements["PTDC_CODIGO"].value==110||
		 document.forms["VIEW_EFXP"].elements["PTDC_CODIGO"].value==111||
		 document.forms["VIEW_EFXP"].elements["PTDC_CODIGO"].value==112) {

	if (document.getElementById("EDFE_PAIS_DEST")!=null&&document.getElementById("EDFE_PAIS_DEST").value=='0') {
		errMsg += "Seleccione pais de destino\n";
		if (elemento == null) elemento = f.elements["EDFE_PAIS_DEST"]
	}
	if (document.getElementById("EDFE_TPO_MON")!=null&&document.getElementById("EDFE_TPO_MON").value=='0') {
		errMsg += "Seleccione tipo de moneda\n";
		if (elemento == null) elemento = f.elements["EDFE_TPO_MON"]
	}
	
	if(f.elements["EDFE_TPO_EXPO"]!=null && f.elements["EDFE_TPO_EXPO"].value!='3' && f.elements["EDFE_TPO_EXPO"].value!='4'  && f.elements["EDFE_TPO_EXPO"].value!='6' ) {
		if (document.getElementById("EDFE_MOD_VTA")!=null&&document.getElementById("EDFE_MOD_VTA").value=='') {
			errMsg += "Seleccione modalidad de venta\n";
			if (elemento == null) elemento = f.elements["EDFE_MOD_VTA"]
		}

		if (f.elements["EDFE_PTO_EMBAR"]!=null) {
			if(sinInfo(f.elements["EDFE_PTO_EMBAR"].value) == true) {
				errMsg += "Debe ingresar Puerto Embarque\n";
				if (elemento == null) elemento = f.elements["EDFE_PTO_EMBAR"];
			}
			else {
				var temp = Number(f.elements["EDFE_PTO_EMBAR"].value);
				if (temp == NaN) {
					errMsg += "Valor Puerto Embarque debe ser numérico\n";
					if (elemento == null) elemento = f.elements["EDFE_PTO_EMBAR"];
				}
				else if(temp== 0) {
					errMsg += "Valor Puerto Embarque debe ser mayor que 0\n";
					if (elemento == null) elemento = f.elements["EDFE_PTO_EMBAR"];
				}
			}
		}
		if (f.elements["EDFE_PTO_DESEM"]!=null) {
			if (sinInfo(f.elements["EDFE_PTO_DESEM"].value) == true) {
				errMsg += "Debe ingresar Puerto Desembarque\n";
				if (elemento == null) elemento = f.elements["EDFE_PTO_DESEM"];
			}
			else {
				var temp = Number(f.elements["EDFE_PTO_DESEM"].value);
				if (temp == NaN) {
					errMsg += "Valor Puerto Desembarque debe ser numérico\n";
					if (elemento == null) elemento = f.elements["EDFE_PTO_DESEM"];
				}
				else if(temp== 0) {
					errMsg += "Valor Puerto Desembarque debe ser mayor que 0\n";
					if (elemento == null) elemento = f.elements["EDFE_PTO_DESEM"];
				}
			}
		}
	
		if (f.elements["EDFE_TOT_BOLT"]!=null) {
			var temp = Number(f.elements["EDFE_TOT_BOLT"].value);
			if (temp == NaN) {
				errMsg += "Valor total de bultos debe ser numérico\n";
				if (elemento == null) elemento = f.elements["EDFE_TOT_BOLT"];
			}
			if(temp<=0) {
				errMsg += "Valor total de bultos debe ser mayor que 0\n";
				if (elemento == null) elemento = f.elements["EDFE_TOT_BOLT"];
			}
		}
	} else {
		if (f.elements["EDFE_PTO_EMBAR"]!=null) {
			if(!sinInfo(f.elements["EDFE_PTO_EMBAR"].value) == true) {
				var temp = Number(f.elements["EDFE_PTO_EMBAR"].value);
				if (temp == NaN) {
					errMsg += "Valor Puerto Embarque debe ser numérico\n";
					if (elemento == null) elemento = f.elements["EDFE_PTO_EMBAR"];
				}
				else if(temp== 0) {
					errMsg += "Valor Puerto Embarque debe ser mayor que 0\n";
					if (elemento == null) elemento = f.elements["EDFE_PTO_EMBAR"];
				}
			}
		}
		if (f.elements["EDFE_PTO_DESEM"]!=null) {
			if (!sinInfo(f.elements["EDFE_PTO_DESEM"].value) == true) {
				var temp = Number(f.elements["EDFE_PTO_DESEM"].value);
				if (temp == NaN) {
					errMsg += "Valor Puerto Desembarque debe ser numérico\n";
					if (elemento == null) elemento = f.elements["EDFE_PTO_DESEM"];
				}
				else if(temp== 0) {
					errMsg += "Valor Puerto Desembarque debe ser mayor que 0\n";
					if (elemento == null) elemento = f.elements["EDFE_PTO_DESEM"];
				}
			}
		}
	
		if (f.elements["EDFE_TOT_BOLT"]!=null) {
			var temp = Number(f.elements["EDFE_TOT_BOLT"].value);
			if (temp == NaN) {
				errMsg += "Valor total de bultos debe ser numérico\n";
				if (elemento == null) elemento = f.elements["EDFE_TOT_BOLT"];
			}
			if((!sinInfo(f.elements["EDFE_TOT_BOLT"].value) == true) && temp<=0) {
				errMsg += "Valor total de bultos debe ser mayor que 0\n";
				if (elemento == null) elemento = f.elements["EDFE_TOT_BOLT"];
			}
		}
	}

	if(f.elements["PTDC_CODIGO"].value == 110){
		if (f.elements["EDFE_TPO_CAMBIO"]!=null) {
			if (sinInfo(f.elements["EDFE_TPO_CAMBIO"].value) == true) {
				errMsg += "Debe ingresar Tipo Cambio a Pesos\n";
				if (elemento == null) elemento = f.elements["EDFE_TPO_CAMBIO"];
			}
			else {						 	
				var cambioPeso =  Number(f.elements["EDFE_TPO_CAMBIO"].value);
				patron3 = /^[0-9]{1,6}(\.[0-9]{1,4}){0,1}$/;					      
				if(!(patron3.test(cambioPeso))){					    	   
					errMsg += "Valor Tipo Cambio a Pesos debe ser mínimo 0.0001 y máximo 999999.9999\n";
					if (elemento == null) elemento = f.elements["EDFE_TPO_CAMBIO"];  					    	 					    	
				}else if(cambioPeso < 0.0001 || cambioPeso>999999.9999){
					errMsg += "Valor Tipo Cambio a Pesos debe ser mínimo 0.0001 y máximo 999999.9999\n";
					if (elemento == null) elemento = f.elements["EDFE_TPO_CAMBIO"];  
				}
			}
		}
	}

  }	//Fac. Expo
  
  
	if( (f.elements["PTDC_CODIGO"].value == 33 ||  f.elements["PTDC_CODIGO"].value == 52) && f.elements["EFXP_RUT_TRANSPORTE"]!=null  ) {
		var rutTransporte = f.elements["EFXP_RUT_TRANSPORTE"];
		var dvTransporte = f.elements["EFXP_DV_TRANSPORTE"];
		var patente = f.elements["EFXP_PATENTE"];
		var rutChofer = f.elements["EFXP_RUT_CHOFER"];
		var dvChofer = f.elements["EFXP_DV_CHOFER"];
		var nombreChofer = f.elements["EFXP_NOMBRE_CHOFER"];
		var sinInfoRutTransporte = sinInfo(rutTransporte.value);
		var sinInfoDvTransporte = sinInfo(dvTransporte.value);
		var sinInfoPatente = sinInfo(patente.value);
		var sinInfoRutChofer = sinInfo(rutChofer.value);
		var sinInfoDvChofer = sinInfo(dvChofer.value);
		var sinInfoNombreChofer = sinInfo(nombreChofer.value);
		if (  sinInfoRutTransporte && sinInfoDvTransporte && sinInfoPatente && sinInfoRutChofer && sinInfoDvChofer && sinInfoNombreChofer  ) {
			// no trae info de transporte
		}
		else if (  !sinInfoRutTransporte && !sinInfoDvTransporte && !sinInfoPatente && !sinInfoRutChofer && !sinInfoDvChofer && !sinInfoNombreChofer  ) {
			// trae info de transporte, valido ruts
			if ( !isNumero(rutTransporte.value) || !validaM11(rutTransporte.value, dvTransporte.value) ) {
				errMsg += "Rut Transporte invalido \n";
				dvTransporte.focus();
			}
			if (  !isNumero(rutChofer.value) || !validaM11(rutChofer.value, dvChofer.value) ) {
				errMsg += "Rut Chofer invalido \n";
				dvChofer.focus();
			}
		}
		else {
			errMsg += "Info de transporte incompleta. Debe llenar todos los campos.\n";
			if ( sinInfoRutTransporte ) rutTransporte.focus();
			if ( sinInfoDvTransporte ) dvTransporte.focus();
			if ( sinInfoPatente ) patente.focus();
			if ( sinInfoRutChofer ) rutChofer.focus();
			if ( sinInfoDvChofer ) dvChofer.focus();
			if ( sinInfoNombreChofer ) nombreChofer.focus();
		}
	}
	
	if (  f.elements["OTRO_IMP_SI_NO"]!=null && f.elements["OTRO_IMP_SI_NO"].checked == true) {	
		if (f.elements["EFXP_OTRO_IMP_TOTAL"].value==0) {
			errMsg += "Impuesto Adicional debe ser mayor a 0 \n";
		}
	}

	var i;
	var linea;
	var msgTemp;
	var cantidadLineas =0;

	var cantDetalle = document.forms["VIEW_EFXP"].elements["CANT_DET"].value;
	if (cantDetalle.length == 0) cantDetalle = 1;

	calculaRelacionadoFacEx(f.elements["EFXP_QTY_01"]);
	for(i = 1; i <= MAX_LINEA && i <= cantDetalle; i++) {
		if (i < MAX_LINEA) {
			 linea = '0'+i;
		} else {
			 linea = i;
		}
		if (sinInfo(f.elements["EFXP_QTY_"+linea].value) == false) {
			cantidadLineas++;
		}
		msgTemp = validaLinDet(f, linea);
		if (msgTemp.length > 0) {
			errMsg += msgTemp;
			if (elemento == null) elemento = f.elements["EFXP_NMB_"+linea];
		}
	}

	if (errMsg.length > 0) {
		alert(errMsg);
		if (elemento != null) elemento.focus();
		return false;
	}

	if (!revisaCamposSoloISO8859(f,MAX_LINEA)) return false;

	cantidadLineas += Math.floor(cantidadLineas/4);

	for(i = 1; i <= MAX_LINEA; i++) {
		if (i < MAX_LINEA)
			 linea = '0'+i;
		else
			 linea = i;

		if (f.elements["EFXP_DSC_ITEM_"+linea] != null && f.elements["EFXP_DSC_ITEM_"+linea].value!="")
			cantidadLineas += calculaCantLineas(f.elements["EFXP_DSC_ITEM_"+linea].value);
	}

	if (f.elements["OTRO_IMP_SI_NO"] != null && f.elements["OTRO_IMP_SI_NO"].checked) cantidadLineas ++;

	if (f.elements["REF_SI_NO"] != null && f.elements["REF_SI_NO"].checked) {
		for(i=1; i<=3; i++) {
			if (f.elements["EFXP_FOLIO_REF_00"+i] != null && f.elements["EFXP_FOLIO_REF_00"+i].value!="") cantidadLineas ++;
		}
		cantidadLineas ++;
	}

	if (f.elements["PAGO_SI_NO"] != null && f.elements["PAGO_SI_NO"].checked) {
		for(i=1; i<=3; i++) {
			if (f.elements["EFXP_MNT_PAGO_00"+i] != null && f.elements["EFXP_MNT_PAGO_00"+i].value!="") cantidadLineas ++;
		}
		cantidadLineas ++;
	}

  if (eExpo)
		MAX_LIN_IMP=12;

	if (cantidadLineas > MAX_LIN_IMP-1) {
		alert('La cantidad de caracteres ingresados excede el máximo permitido. Por favor disminuya la cantidad de caracteres ingresados en la(s) descripcion(es) extendida(s) y/o la cantidad de lineas para generar correctamente el documento.');
		return false;
	}

	for( i = 0; i < cantTotCol; i++) {
		if (datosArray[i][7][indValue].length > 0) {
			datosArray[i][10][indValue] = datosArray[i][10][indValue] + '\n* Impuesto Adic.: '+getGlosaOtrosImp(datosArray[i][7][indValue]);
			if(f.elements[datosArray[i][3][indName]]!=null) {
				f.elements[datosArray[i][3][indName]].checked = true;
				dibujaTextArea(f.elements[datosArray[i][3][indName]]);
			}
		}
	}
	
	
  if (esFACT_TUR != null && esFACT_TUR.value == 'TRUE') {
		alert('Verifique que los datos que identifican al Turista Extranjero corresponden a la documentación que porta.  Caso contrario no podrá acceder al beneficio de devolución de IVA Turista.');
  }

	return true;
}

function lineas_X_Frase(frase) {
	var retorno = 1;
	var temp = 0;

	if ((frase != null) && (frase.length > 0)) {
		temp = frase.length;
		while (temp > CARCATERTES_X_LINEA) {
			temp = temp - CARCATERTES_X_LINEA;
			retorno += 1;
		}
	}
	return retorno;
}

function calculaCantLineas(descripcion) {

	var cantLineas = 0;
	var temp;
	var ind0 = 0;
	var ind1 = 0;

	if (descripcion == null || descripcion.length == 0) return cantLineas;

	ind1 = descripcion.indexOf('\n');  // se usa solo \n , porque \r\n no siempre los encuentra
	if (ind1 == -1) {
			cantLineas = lineas_X_Frase(descripcion);
			return cantLineas;
	} else {
		while (ind1 != -1) {
			cantLineas += lineas_X_Frase(descripcion.substring(ind0,ind1));
			ind0 = ind1 +1;
			ind1 = descripcion.indexOf('\n',ind0);
		}
		cantLineas += lineas_X_Frase(descripcion.substring(ind0,ind1));
	}
	return cantLineas;
}

function confirmarEliminacion() {
	return confirm("Seguro que desea elmiminar factura?");
}

function cierraVentana(origen) {

	var i, j;
	var exiteMasReg;
	var f = document.forms["VIEW_EFXP"];

	if (origen == 'CGI') {
		modDir(f.elements["EFXP_DIR_ORIGEN_DEFUALT"]);
		modDir(f.elements["EFXP_DIR_RECEP_DEFUALT"]);

		for( i = 0; i < f.elements["EFXP_ACTECO_SELECT"].length; i++) {
			if ( f.elements["EFXP_ACTECO_SELECT"].options[i].value == f.elements["EFXP_ACTECO"].value)
				f.elements["EFXP_ACTECO_SELECT"].selectedIndex = i;
		}
		modActEco(f.elements["EFXP_ACTECO_SELECT"]);

		if(f.elements["EFXP_GIRO_RECEP"]!=null) for( i = 0; i < f.elements["EFXP_GIRO_RECEP"].length; i++) {
			if ( f.elements["EFXP_GIRO_RECEP"].options[i].value == f.elements["EFXP_GIRO_RECEP_DEFUALT"].value)
				f.elements["EFXP_GIRO_RECEP"].selectedIndex = i;
		}

		if (f.elements["UBIC_MADERA_SI_NO"] != null) {
			f.elements["UBIC_MADERA_SI_NO"].checked = (ubicMaderaChecked == 'SiChecked') || (varExiMaderaArr() == true);
		}
		f.elements["REF_SI_NO"].checked = (RefeneciasChecked == 'SiChecked') || (varExiReferenArr() == true);
		f.elements["PAGO_SI_NO"].checked = (PagoChecked == 'SiChecked') || (varExiPagosArr() == true);
		f.elements["COD_SI_NO"].checked = (codChecked == 'SiChecked') || (varExiCodDetalleArr() == true);

		if(f.elements["OTRO_IMP_SI_NO"]!=null) 
			f.elements["OTRO_IMP_SI_NO"].checked = (otroImpChecked == 'SiChecked') || (varExiOtroImpArr()== true);

		if(f.elements["EMP_MENOR_TAMANO"]!=null) 
			f.elements["EMP_MENOR_TAMANO"].checked = empMenorTamanoChecked == 'SiChecked';

		for( i = 3; i < 10; i++) {
			if ( (datosArray[i][0][indValue].length > 0) || (datosArray[i][1][indValue].length > 0) ||
					 (datosArray[i][2][indValue].length > 0) || (datosArray[i][4][indValue].length > 0) ||
					 (datosArray[i][5][indValue].length > 0) || (datosArray[i][6][indValue].length > 0) ||
					 (datosArray[i][7][indValue].length > 0) || (datosArray[i][9][indValue].length > 0)
				 ) {
				datosArray[i][11][0] = 'VIS';
				if (datosArray[i][10][indValue].length > 0) datosArray[i][11][1] = 'VIS';
			}
		}

		printUbicacion(1);
		printReferencias();
		dibujaDetalles();
	}
}


function  calculaTotOtroImp(tipoImp, subtotal) {
	var retorno = 0.0;
	var tasa = getTasa(tipoImp);

	if (tasa!=-1) retorno = subtotal * (tasa/100.0);

	return retorno;
}


function valEFXP_CRED_EC(elemento) {
	var pattern = /^\d+$/;

	if(!pattern.test(elemento.value)) {
		alert("Valor debe ser numérico y no puede ser decimal.");
		elemento.focus();
		return;
	}

	var descCRED_EC = 0;
	var temp = Number(elemento.value);

	if (temp == NaN) {
		alert("Valor debe ser numérico.");
		elemento.focus();
		return;
	}

	descCRED_EC = temp;

	var auxIva = 0;
	var f = elemento.form;
	temp = Number(f.elements["EFXP_IVA"].value);
	if (temp == NaN) {
		alert("Valor debe ser numérico y no puede ser decimal.");
		return;
	}
	auxIva = temp;

	temp = auxIva * (65/100);
	if (temp != NaN) {
		if(descCRED_EC>Math.round(temp)) {
			alert("Valor debe ser menor o igual al 65% del IVA(" + Math.round(temp) + ").");
			return;
		}
	}
	calculaRelacionadoFacEx(elemento);
}

function calculaTotalesFacEx(f, elemento) { // f es el formulario
	var total = 0;
	var totOtrImp = 0.0;	
	var temp;
	var i;
	var subTotName = "EFXP_SUBT_";

	var cantDetalle = f.elements["CANT_DET"].value;

	if (cantDetalle.length == 0) cantDetalle = 1;

	for (i = 1 ; i <= MAX_LINEA && i <= cantDetalle; i++) {
		if (i < MAX_LINEA) {
				numLinea = '0'+i;
		} else {
				numLinea = i;
		}
		subTotName = "EFXP_SUBT_" + numLinea;

		temp = Number(f.elements[subTotName].value);
		if (temp != NaN) {
			total = total + temp;
			if ( f.elements["OTRO_IMP_SI_NO"]!=null&&(f.elements["OTRO_IMP_SI_NO"].checked == true) &&
					 (f.elements["PTDC_CODIGO"].value == 33)) {
				totOtrImp += calculaTotOtroImp(datosArray[i-1][7][indValue], temp);
			}
		}
	}

	f.elements["EFXP_SUBTOTAL"].value = total;

	if (elemento.name == "EFXP_PCT_DESC")
		f.elements["EFXP_MNT_DESC"].value = Math.round(f.elements["EFXP_SUBTOTAL"].value * (elemento.value/100));
	else if (elemento.name == "EFXP_MNT_DESC")
		f.elements["EFXP_PCT_DESC"].value = Math.round(parseFloat((elemento.value * 100) / f.elements["EFXP_SUBTOTAL"].value)*100)/100;
	else if (f.elements["EFXP_PCT_DESC"].value.length > 0 ) {
		temp = Math.round(f.elements["EFXP_PCT_DESC"].value*100)/100;
		f.elements["EFXP_PCT_DESC"].value = temp;
		f.elements["EFXP_MNT_DESC"].value = Math.round(f.elements["EFXP_SUBTOTAL"].value * (f.elements["EFXP_PCT_DESC"].value/100));
	}
	else if (f.elements["EFXP_MNT_DESC"].value.length > 0) {
		f.elements["EFXP_PCT_DESC"].value = Math.round(parseFloat((f.elements["EFXP_MNT_DESC"].value * 100) / f.elements["EFXP_SUBTOTAL"].value)*100)/100;
	}
	else {
		f.elements["EFXP_MNT_DESC"].value = 0;
		f.elements["EFXP_PCT_DESC"].value = 0;
	}

	var descCRED_EC = 0;

	temp = Number(f.elements["EFXP_MNT_DESC"].value);

	if (temp != NaN) f.elements["EFXP_MNT_NETO"].value = total - temp;

	if (f.elements["PTDC_CODIGO"].value == 33) {
		temp = Number(f.elements["EFXP_MNT_NETO"].value) * (Number(f.elements["EFXP_TASA_IVA"].value)/100);
		if (temp != NaN) {
			f.elements["EFXP_IVA"].value = Math.round(temp);
			//INI VAL CEC Aqui cambio si tiene Credito Empresa Constructora si IVA cambia cambia CEC
			if (f.elements["EFXP_CRED_EC"]!=null) {
				temp = Number(f.elements["EFXP_CRED_EC"].value);

				if (temp != NaN) {
					descCRED_EC = temp;

					var auxIva = 0;
					temp = Number(f.elements["EFXP_IVA"].value);
					if (temp != NaN) {
						auxIva = temp;

						temp = auxIva * (65/100);
						if (temp!=NaN&&descCRED_EC>Math.round(temp)) {
							descCRED_EC = Math.round(temp);
							f.elements["EFXP_CRED_EC"].value = descCRED_EC;
						}
					}
				}
			}
			//FIN VAL CEC
		}
		temp = Number(f.elements["EFXP_IVA"].value) + Number(f.elements["EFXP_MNT_NETO"].value);
	} else {
		temp = f.elements["EFXP_MNT_NETO"].value;
	}

	if (temp != NaN) {
		if ( f.elements["OTRO_IMP_SI_NO"]!=null&&(f.elements["OTRO_IMP_SI_NO"].checked == true)  &&
				 (f.elements["PTDC_CODIGO"].value == 33)) {
			f.elements["EFXP_OTRO_IMP_TOTAL"].value = Math.round(totOtrImp * (1.0 - (Number(f.elements["EFXP_PCT_DESC"].value))/100.0));
			f.elements["EFXP_MNT_TOTAL"].value = Number(f.elements["EFXP_OTRO_IMP_TOTAL"].value) + Math.round(temp) - descCRED_EC;
		}
		else {
				f.elements["EFXP_MNT_TOTAL"].value = Math.round(temp) - descCRED_EC;
		}
	}
}
// function calculaRelacionadoFacEx(elemento) {

// 	var f = elemento.form;
// 	var descuento  = 1;
// 	var precio     = 0;
// 	var cantidad   = 0;
// 	var porcentaje = 0.0;
// 	var monto      = 0;

// 	var numLinea = 0;
// 	var i=0;
// 	var cantName;
// 	var precioName;
// 	var descName;
// 	var subTotName;
// 	var temp;

// 	if (isNaN(Number(elemento.value))) {
// 		alert('Este campo solo puede ser numerico');
// 		elemento.focus();
// 		return;
// 	}

// 	if ((elemento.name.substr(0,10) == "EFXP_PCTD_") &&(Number(elemento.value) > 100)) {
// 		alert('El porcentaje no puede ser mayor que 100');
// 		elemento.focus();
// 		return;
// 	}

// 	var cantDetalle = document.forms["VIEW_EFXP"].elements["CANT_DET"].value;

// 	if (cantDetalle.length == 0) cantDetalle = 1;

// 	for (i = 1 ; i <= 10 && i <= cantDetalle; i++) {
// 		if (i < MAX_LINEA) {
// 				numLinea = '0'+i;
// 		} else {
// 				numLinea = i;
// 		}
// 		precioName = "EFXP_PRC_"+numLinea;
// 		descName = "EFXP_PCTD_"+numLinea;
// 		cantName = "EFXP_QTY_"+numLinea;
// 		subTotName = "EFXP_SUBT_"+numLinea;

// 		if ( ((sinInfo(f.elements[cantName].value)   == true) || (f.elements[cantName].value == 0)) &&
// 				 ((sinInfo(f.elements[precioName].value) == true) || (f.elements[precioName].value == 0)) &&
// 				 ((sinInfo(f.elements[descName].value)   == true) || (f.elements[descName].value == 0))
// 			 ) {
// 				f.elements[cantName].value = '';
// 				f.elements[precioName].value = '';
// 				f.elements[descName].value = '';
// 				f.elements[subTotName].value = '';
// 		}
// 		else {
// 			if (f.elements[descName].value != 0) {
// 				temp = Math.round(f.elements[descName].value*100)/100;
// 				f.elements[descName].value = temp;
// 				descuento = 1-(f.elements[descName].value /100);
// 			}
// 			else {
// 				descuento = 1;
// 			}
// 			if (f.elements[precioName].value!=null && f.elements[precioName].value!='') {
// 				temp = Math.round(f.elements[precioName].value*100)/100;
// 				f.elements[precioName].value = temp;
// 			}
// 			if (f.elements[cantName].value!=null && f.elements[cantName].value!='') {
// 				temp = Math.round(f.elements[cantName].value*100)/100;
// 				f.elements[cantName].value = temp;
// 			}

// 			precio   = f.elements[precioName].value;
// 			cantidad = f.elements[cantName].value;
// 			if (precio!=null && cantidad!=null) {
// 				f.elements[subTotName].value = Math.round(precio * cantidad * descuento);
// 				insArr(f.elements[subTotName]); // hay que actializar el arreglo
// 			}
// 		}
// 	}
// 	calculaTotalesFacEx(f,elemento);
// }


function goNextFacEx(elemento) {

	var f = elemento.form;

	var i;
	var linea;
	var lineaNext;
	var msgTemp;
	var sobTotName = "EFXP_SUBT_";
	var nomName = "EFXP_NMB_";

	if (elemento.name.indexOf(sobTotName) == 0) {
		for(i = 1; i <= MAX_LINEA; i++) {
			if (i < MAX_LINEA) {
				 linea = '0'+i;
				 if (i < 9) {
						 lineaNext = '0'+(i+1);
				 } else {
						 lineaNext = 10;
				 }
			} else {
				 linea = i;
			}
			if (elemento.name == (sobTotName+linea)) {
				if (linea <= 9) 
					f.elements[nomName+lineaNext].focus();
				else
					f.elements["EFXP_PCT_DESC"].focus();
			}
		}
	}
	else if (elemento.name == "EFXP_SUBTOTAL") f.elements["EFXP_PCT_DESC"].focus();
	else if (elemento.name == "EFXP_MNT_NETO") f.elements["EFXP_NMB_01"].focus();
	else if (elemento.name == "EFXP_TASA_IVA") f.elements["EFXP_NMB_01"].focus();
	else if (elemento.name == "EFXP_IVA")  f.elements["EFXP_NMB_01"].focus();
	else if (elemento.name == "EFXP_MNT_TOTAL") f.elements["EFXP_NMB_01"].focus();
}

function compareStringCod(strCod, strNormal) {
	var pos1;
	var str1;

	if (strCod == strNormal) return true;

	pos1 = strCod.indexOf("&#");
	if ((pos1 != -1) && (strCod.substr(0,pos1) == strNormal.substr(0, pos1))) {
		return compareStringCod(  strCod.slice(strCod.indexOf(";",pos1)+1, strCod.length), strNormal.slice(pos1+1, strNormal.length));
	}

	return false;
}

function getComuna(direccion, arrDireccion) {
	var i = 0;
	var retorno = arrDireccion[0][1];

  while (arrDireccion[i][1] != "0") {
		if (compareStringCod(arrDireccion[i][0], direccion)) {
			retorno = arrDireccion[i][1];
			break;
		}
		i++;
  }
  if (retorno == 0) return "";

	return retorno;
}

function getCiudad(direccion, arrDireccion) {
	var i = 0;
	var retorno = arrDireccion[0][2];

  while (arrDireccion[i][1] != "0") {
		if (compareStringCod(arrDireccion[i][0],direccion)) {
			retorno = arrDireccion[i][2];
			break;
		}
		i++;
  }
  if (retorno == 0) return "";

	return retorno;
}

function getCodSuc(direccion, arrDireccion) {
	var i = 0;
	var retorno = arrDireccion[0][3];

  while (arrDireccion[i][1] != "0") {
		if (compareStringCod(arrDireccion[i][0], direccion)) {
			retorno = arrDireccion[i][3];
			break;
		}
		i++;
  }
  if (retorno == 0) return "";

	return retorno;
}

function getFono(direccion, arrDireccion) {
	var i = 0;
	var retorno = arrDireccion[0][4];

  while (arrDireccion[i][1] != "0") {
		if (compareStringCod(arrDireccion[i][0], direccion)) {
			retorno = arrDireccion[i][4];
			break;
		}
		i++;
  }
  if (retorno == 0) return "";
  
	return retorno;
}

function modDir(elemento){
	if(elemento==null) return 1;
	var f = elemento.form;

	if (elemento.name == "EFXP_DIR_RECEP") {
		if(!eExpo) {
			if(f.elements["EFXP_CMNA_RECEP"]!=null) f.elements["EFXP_CMNA_RECEP"].value = getComuna(elemento.value, recptorDir);
			if(f.elements["EFXP_CIUDAD_RECEP"]!=null) f.elements["EFXP_CIUDAD_RECEP"].value = getCiudad(elemento.value, recptorDir);
		}
	}
	else if (elemento.name == "EFXP_DIR_ORIGEN"){
		f.elements["EFXP_CMNA_ORIGEN"].value = getComuna(elemento.value, emisorDir);
		f.elements["EFXP_CIUDAD_ORIGEN"].value = getCiudad(elemento.value, emisorDir);
		f.elements["EFXP_CDG_SII_SUCUR"].value = getCodSuc(elemento.value, emisorDir);
		f.elements["EFXP_FONO_EMISOR"].value = getFono(elemento.value, emisorDir);

	}
	else if (elemento.name == "EFXP_DIR_RECEP_DEFUALT") {
		if(f.elements["EFXP_DIR_RECEP"]!=null) {
			for( i = 0; i < f.elements["EFXP_DIR_RECEP"].length; i++) {
				if ( f.elements["EFXP_DIR_RECEP"].options[i].value == elemento.value) {
					f.elements["EFXP_DIR_RECEP"].selectedIndex = i;
				}
			}
		}
		if(!eExpo) {
			f.elements["EFXP_CMNA_RECEP"].value = getComuna(elemento.value, recptorDir);
			f.elements["EFXP_CIUDAD_RECEP"].value = getCiudad(elemento.value, recptorDir);
		}
	}
	else if (elemento.name == "EFXP_DIR_ORIGEN_DEFUALT") {
		for( i = 0; i < f.elements["EFXP_DIR_ORIGEN"].length; i++) {
			if ( f.elements["EFXP_DIR_ORIGEN"].options[i].value == elemento.value)  f.elements["EFXP_DIR_ORIGEN"].selectedIndex = i;
		}
		f.elements["EFXP_CMNA_ORIGEN"].value = getComuna(elemento.value, emisorDir);
		f.elements["EFXP_CIUDAD_ORIGEN"].value = getCiudad(elemento.value, emisorDir);
		f.elements["EFXP_CDG_SII_SUCUR"].value = getCodSuc(elemento.value, emisorDir);
		f.elements["EFXP_FONO_EMISOR"].value = getFono(elemento.value, emisorDir);
	}

	return 1;
}

function insArr(obj) {
	var nombre = new String(obj.name);
	var index = nombre.lastIndexOf('_');
	var i = (parseInt(nombre.substr(index + 1,1))*10 +parseInt(nombre.substr(index+2,1))) -1;
	for(var j=0; j < 10; j++) {
		if (datosArray[i][j][indName] == obj.name) break;
	}
	if (nombre.substr(0,14) == 'EFXP_DSC_ITEM_') {
		var varRegExp = /\n/gi;
		datosArray[i][j][indValue] = obj.value.replace(RegExpFinLinea,'~^');
	}
	else {
		datosArray[i][j][indValue] = obj.value
	}
}

function limpiaDescrip(obj) {
	var f = obj.form;
	var nombre = new String(obj.name);
	var index = nombre.lastIndexOf('_');
	var i = (parseInt(nombre.substr(index+1,1))*10 +parseInt(nombre.substr(index+2,1))) -1;
	if (datosArray[i][10][indValue] == 'Ingrese s&oacute;lo si requiere ingresar una descripci&oacute;n extendida del producto o servicio') {
		obj.value = '';
		datosArray[i][10][indValue] = '';
	}
}

function getGlosaDetalleCAMSUJ(tpoCAMSUJ){

  var temp = ' WHAT??????'+tpoCAMSUJ;
  if(tpoCAMSUJ != 0) temp = 'CALB1 10%';
  return temp;

}

function genSelectCAMSUJ(tpoCAMSUJ) {
	var temp;
	var tpoDoc = document.forms["VIEW_EFXP"].elements["PTDC_CODIGO"].value;
	var tpoSelect;

	if (tpoDoc == 33) tpoSelect = 1;
	else if ((tpoDoc == 56) || (tpoDoc == 61)) tpoSelect = 2;
	else if (tpoDoc == 46) tpoSelect = 3;

	if ((tpoCAMSUJ == null) || (tpoCAMSUJ.length == 0)) temp = '<OPTION VALUE="" selected>NO TIENE</OPTION>';
	else temp = '<OPTION VALUE="">NO TIENE</OPTION>';

	if ((tpoSelect == 3) && (tpoCAMSUJ == 23)) temp += '<OPTION VALUE=23 selected>'+getGlosaDetalleCAMSUJ(23)+'</OPTION>';
	else if ((tpoSelect == 3)) temp += '<OPTION VALUE=23>'+getGlosaDetalleCAMSUJ(23)+'</OPTION>';

	return temp;
}

//20141010_CON: se traslada la funcion genSelectOtrosImp a un JS comun (usado por la factura)

function dibujaTextArea(obj) {
	var nom = new String(obj.name);
	var pos = nom.substring(8,10);
	var tbl = document.getElementById('myTable');
	var row;
	var cel;
	var descripcion = '';
	var i;

	if (obj.checked) {
		row = document.getElementById('rowDet_'+pos);
		i = row.rowIndex;
		row = tbl.insertRow(i+1);
		row.id = 'rowDescripcion_'+pos;
		cel = row.insertCell(0);
		cel.colSpan='9';
		cel.align='center';
		cel.setAttribute("data-title","Descripcion");
		i = Number(pos);
		descripcion = datosArray[i-1][10][indValue];
		if (descripcion.length != 0) {
		} else {
			datosArray[i-1][10][indValue] = 'Ingrese s&oacute;lo si requiere ingresar una descripci&oacute;n extendida del producto o servicio';
		}
		cel.innerHTML='<textarea style="text-align:left; width:100%" onChange="insArr(this)" onfocus="limpiaDescrip(this)" name="EFXP_DSC_ITEM_'+pos+'" >'+ datosArray[i-1][10][indValue].replace(RegExpEscape,'\n') +'</textarea>';
		datosArray[i-1][11][1] = 'VIS';
	}
	else {
		row = document.getElementById('rowDescripcion_'+pos);
		i = row.rowIndex;
		tbl.deleteRow(i);
		i = Number(pos);
		datosArray[i-1][10][indValue] = '';
		datosArray[i-1][11][1] = 'NO_VIS';
	}
}

function ocultaFonoEmail() {
	var tbl = document.getElementById('tblOtroDatosEmisor');
	tbl.deleteRow(0);
}


function dibujaTotOtroImp() {
	var row;
	var f = document.forms["VIEW_EFXP"];

	if (f.elements["OTRO_IMP_SI_NO"]!=null&&f.elements["OTRO_IMP_SI_NO"].checked == true) {
		row = document.getElementById('rowOtrosImp');
		if (row != null) {
			row.style.display = 'inline';
			if (f.elements["EFXP_OTRO_IMP_TOTAL"]!=null)
				f.elements["EFXP_OTRO_IMP_TOTAL"].disabled = false;
		} 
	}
	else {
		row = document.getElementById('rowOtrosImp');
		if (row != null) {
			row.style.display = 'none';
			if (f.elements["EFXP_OTRO_IMP_TOTAL"]!=null)
				f.elements["EFXP_OTRO_IMP_TOTAL"].disabled = true;
		}
	}
}


function dibujaDetalles() {
	var f = document.forms["VIEW_EFXP"];
	var tbl = document.getElementById('myTable');
	var row, cel;
	var i, j, ii;
	var tempText, columna;

	// primero borra la botonera de la tabla y cada fila
	tempText = 'rowDet_Botones';
	row = document.getElementById(tempText);
	if (row != null) {
		j = row.rowIndex;
		tbl.deleteRow(j);
	}
	for (i=1; i<=cantTotCol; i++) {
		tempText = 'rowDet_'+((i<=9)?('0'+i):i);
		row = document.getElementById(tempText);
		if (row != null) {
				j = row.rowIndex;
				tbl.deleteRow(j);
		}
		tempText = 'rowDescripcion_'+((i<=9)?('0'+i):i);
		row = document.getElementById(tempText);
		if (row != null) {
				j = row.rowIndex;
				tbl.deleteRow(j);
		}
	}

	var row = document.getElementById('rowDet_Encabezado');
	if (f.elements["COD_SI_NO"].checked && row.innerHTML.indexOf("Tpo Cod")==-1) {
		cel = document.createElement("TH");
		cel.align='center';
		cel.setAttribute("class","text-center");
		cel.innerHTML = 'Tpo Cod / Codigo';
		row.insertBefore(cel,row.cells[0]);
	}
	else if (!f.elements["COD_SI_NO"].checked && row.innerHTML.indexOf("Tpo Cod")!=-1){
		row.deleteCell(0);
	}
	
	if (f.elements["OTRO_IMP_SI_NO"]!=null && f.elements["OTRO_IMP_SI_NO"].checked && row.innerHTML.indexOf("Impuestos Adic.")==-1) {
		cel = document.createElement("TH");
		cel.align='center';
		cel.setAttribute("class","text-center");
		cel.innerHTML = 'Impuestos Adic.';
		row.insertBefore(cel,row.cells[row.cells.length-2]);
	}
	else if (f.elements["OTRO_IMP_SI_NO"]!=null && !f.elements["OTRO_IMP_SI_NO"].checked && row.innerHTML.indexOf("Impuestos Adic.")!=-1){
		row.deleteCell(row.cells.length-3);
	}

	for (i=0; i < cantTotCol; i++) {
		if (datosArray[i][11][0] == 'VIS') {
			row = tbl.insertRow(i+1);
			columna = (i<9)?('0'+(i+1)):(i+1);
			tempText = 'rowDet_'+ columna;
			row.id = tempText;

			if (f.elements["COD_SI_NO"].checked == true) {
				cel = row.insertCell(-1);
				cel.align='center';
				cel.setAttribute("data-title","Tipo / Codigo");
				cel.setAttribute("class","text-nowrap");
				cel.innerHTML='<INPUT type="text" name="EFXP_TPO_COD_'+columna+'"  value="'+datosArray[i][0][indValue]+'" onchange="insArr(this)" maxLength=10 size=5 ><INPUT type="text" name="EFXP_COD_'+columna+'"  value="'+datosArray[i][1][indValue]+'" onchange="insArr(this)" maxLength=15 size=10 >';
			} 

			cel = row.insertCell(-1);
			cel.align='center';
			cel.setAttribute("data-title","Nombre Prod");
			cel.innerHTML='<INPUT type="text" name="EFXP_NMB_'+columna+'" style="text-align:left; width:100%" value="'+datosArray[i][2][indValue]+'" onchange="insArr(this)" maxLength=25 size=25 >';

			cel = row.insertCell(-1);
			cel.align='center';
			cel.setAttribute("data-title","Descrip");
			cel.innerHTML='<INPUT name="DESCRIP_'+columna+'" style="text-align:left; width:100%" value="DESCRIP_'+columna+'" onclick="dibujaTextArea(this)" type="checkbox" >';

			cel = row.insertCell(-1);
			cel.align='center';
			cel.setAttribute("data-title","Cantidad");
			cel.innerHTML='<input  type="number" style="text-align:right; width:100%" name="EFXP_QTY_'+columna+'" value="'+datosArray[i][4][indValue]+
							'" onchange="insArr(this);calculaRelacionadoFacEx(this);" max="999999999999" step="0.000001" maxLength="12" size="6"/>';

			cel = row.insertCell(-1);
			cel.align='center';
			cel.setAttribute("data-title","Unidad");
			cel.innerHTML='<INPUT name="EFXP_UNMD_'+columna+'" style="text-align:right; width:100% " value="'+datosArray[i][5][indValue]+'" onchange="insArr(this)" maxLength=4  size=5 >';

			cel = row.insertCell(-1);
			cel.align='center';
			cel.setAttribute("data-title","Precio");
			cel.innerHTML='<input  type="number" style="text-align:right; width:100% " name="EFXP_PRC_'+columna+'" value="'+datosArray[i][6][indValue]+
							'" onchange="insArr(this);calculaRelacionadoFacEx(this);" max="999999999999" step="0.000001" maxLength=12 size=10 >';

			ii=6;

			if(f.elements["esCRED_EC"]!=null&&f.elements["esCRED_EC"].value == 'TRUE') {

			}
			else if ( f.elements["OTRO_IMP_SI_NO"]!=null&&(f.elements["OTRO_IMP_SI_NO"].checked == true) &&
						 (f.elements["PTDC_CODIGO"].value == 33)) {
					cel = row.insertCell(-1);
					cel.align='center';
					cel.setAttribute("data-title","Impuestos Adic.");
					cel.innerHTML= '<select onchange="insArr(this);calculaRelacionadoFacEx(this);" name="EFXP_OTRO_IMP_'+columna+'"><optgroup label="Seleccione una opción">'+genSelectOtrosImp(datosArray[i][7][indValue])+'</optgroup></select>';
			}

			cel = row.insertCell(-1);
			cel.align='center';
			cel.setAttribute("data-title","% Desc.");
			cel.innerHTML='<INPUT type="number" name="EFXP_PCTD_'+columna+'" style="text-align:right; width:100%" value="'+datosArray[i][8][indValue]+
							'" onchange="insArr(this);calculaRelacionadoFacEx(this);" max="999" step="0.01" maxLength=12  size=5 >';

			cel = row.insertCell(-1);
			cel.align='center';
			cel.setAttribute("data-title","SubTotal");
			cel.innerHTML='<input  type="number" style="text-align:right; width:100%" name="EFXP_SUBT_'+columna+'" value="'+datosArray[i][9][indValue]+'" style="COLOR: #666666"  onchange="insArr(this)" onfocus="blur()" maxLength="10" size="10" />';
		}
		else {
			for (j=i; j < cantTotCol; j++) {
				if (datosArray[j][9][indValue].length > 0) break;
			}

			if (j == cantTotCol) {
				break;
			}
			else {
				datosArray[i][11][0] = 'VIS';i--;
			}
		}
	}
	f.elements["CANT_DET"].value = i;
	row = tbl.insertRow(i+1);
	tempText = 'rowDet_Botones';
	row.id = tempText;
	cel = document.createElement("TH");
	cel.align='center';
	cel.colSpan="9";
	cel.setAttribute("class","text-center");
	row.appendChild(cel);

  efactura=readCookie("E-FACTURA");
  if (efactura != null) {
    tipoBoton="btn-primary";
    estiloBoton="style=\"border-color: #eb510d; background-color: #eb510d; color: #fff;\"";
  } else {
    tipoBoton="btn-default";
    estiloBoton="";
  }

	if (i == 1) {
		cel.innerHTML = '<INPUT onClick="modCantLineaDet(this);" name=AGREGA_DETALLE type="button" class="btn '+tipoBoton+' btn-sm" '+estiloBoton+' value="Agrega linea de Detalle">';
	} else if (i == 10) {
		cel.innerHTML = '<INPUT onClick="modCantLineaDet(this);" name=QUITA_DETALLE type="button" class="btn '+tipoBoton+' btn-sm" '+estiloBoton+' value="Quita linea de Detalle">';
	} else {
		cel.innerHTML = '<INPUT onClick="modCantLineaDet(this);" name=AGREGA_DETALLE type="button" class="btn '+tipoBoton+' btn-sm" '+estiloBoton+' value="Agrega linea de Detalle">&nbsp;<INPUT class="btn '+tipoBoton+' btn-sm" '+estiloBoton+' onClick="modCantLineaDet(this);" name="QUITA_DETALLE" type="button" value="Quita linea de Detalle">';
	}

	for( i = 0; i < cantTotCol; i++) {
		if (datosArray[i][11][0] == 'VIS' && datosArray[i][10][indValue].length > 0) {
			f.elements[datosArray[i][3][indName]].checked = true;
			dibujaTextArea(f.elements[datosArray[i][3][indName]]);
		}
	}

	if (f.elements["PTDC_CODIGO"].value == 33) dibujaTotOtroImp();
	// calculaRelacionadoFacEx(f.elements["EFXP_QTY_01"]);
}

function modCantLineaDet(obj) {

	var nom = new String(obj.name);
	var i = 0;
	var cantDet = 0;
	var columna;

	while (i < cantTotCol) {
		 if (datosArray[i][11][0] == 'VIS') {
				 cantDet++;
		 }
		 i++;
	}

	if (nom == 'AGREGA_DETALLE') {
		cantDet++;
		if (cantDet == 10) columna = ''+cantDet;
		else columna = '0'+cantDet;

		datosArray[cantDet-1][11][0] = 'VIS';
	}
	else if (nom == 'QUITA_DETALLE') {
		datosArray[cantDet-1][11][0] = 'NO_VIS';
		datosArray[cantDet-1][11][1] = 'NO_VIS';
		datosArray[cantDet-1][7][indValue] = ''; // se cambia de 9 a 7, para evitar error al borrar detalles con impuesto adicional
	}
	for (i = 0, cantDet = 0; i < cantTotCol; i++) {
		if (datosArray[i][11][0] == 'VIS') cantDet++;
	}
	document.forms["VIEW_EFXP"].elements["CANT_DET"].value = cantDet;
	dibujaDetalles();
}

function getActEco(giro, arrEctEco) {
	var i = 0;
	var retorno = arrEctEco[0][0];

	while (arrEctEco[i][1] != "0") {
		 if (compareStringCod(arrEctEco[i][0], giro)) {
			 retorno = arrEctEco[i][0];
			 break;
		 }
		i++;
	}
	return retorno;
}

function modActEco(elemento){
	var f = elemento.form;

	f.elements["EFXP_ACTECO"].value = getActEco(elemento.options[elemento.selectedIndex].value, emisorActEco);

	return 1;
}

function printEmisorDir(){
	var i = 0;

  document.write('<select class="form-control" onchange="modDir(this)" name="EFXP_DIR_ORIGEN">');
  document.write('<optgroup label="Seleccione una opción">');
	while (emisorDir[i][0] != "0") {
		document.write('<option value="'+emisorDir[i][0]+'">'+emisorDir[i][0]+'</option>');
		i++;
	}
  document.write('</optgroup">');
	document.write('</select>');
}

function printEmisorActEco(){
  var i = 0;

  document.write('<select class="form-control" onchange="modActEco(this)" name="EFXP_ACTECO_SELECT">');
  document.write('<optgroup label="Seleccione una opción">');
  while (emisorActEco[i][1] != "0") {
    document.write('<option value="'+emisorActEco[i][0]+'">'+emisorActEco[i][1]+'</option>');
    i++;
  }
  document.write('</optgroup">');
  document.write('</select>');
}

function setFolioXIndRefGlb(obj) {
	var f = obj.form;
	var folioRef = "EFXP_FOLIO_REF_";
	var IndGlbRef = "EFXP_IND_GLOBAL_";
	var numLinea;

	numLinea = obj.name.substr(obj.name.lastIndexOf("_")+1,3);

	if (sinInfo(obj.value) == true) return;

	if (obj.value == 1) {
		f.elements[folioRef+numLinea].value = 0;
	} else {
		alert('Si ingresa Ind.(Indicador de Referencia Global) esto solo puede tener valor 1\n');
		obj.focus();
		return;
	}
}


function insArrUbic(obj) {
    var nombre = new String(obj.name);
    if (nombre.indexOf("EFXP_COMUNA_ROL_ORIGEN") != -1) {
        obj.value = parseInt(obj.value);
        arrUbic[0] = obj.value;
        actualizaComunaMaderaInput(obj);
    } else if (nombre.indexOf("EFXP_MAN_ROL_ORIGEN") != -1) {
        obj.value = parseInt(obj.value);
        arrUbic[1] = obj.value;
    } else if (nombre.indexOf("EFXP_PRED_ROL_ORIGEN") != -1) {
        obj.value = parseInt(obj.value);
        arrUbic[2] = obj.value;
    } else if (nombre.indexOf("EFXP_SIST_REF_GEO") != -1) {
        arrUbic[3] = obj.value;
    } else if (nombre.indexOf("EFXP_LAT_ORIG_MADERA") != -1) {
        arrUbic[4] = obj.value;
    } else if (nombre.indexOf("EFXP_LONG_ORIG_MADERA") != -1) {
        arrUbic[5] = obj.value;
    } else if (nombre.indexOf("EFXP_COD_PLAN_CONAF") != -1) {
        obj.value = parseInt(obj.value);
        arrUbic[6] = obj.value;
    }
}

function insArrReferen(obj) {

    var nombre = new String(obj.name);
    var index = nombre.lastIndexOf('_');
    var i = parseInt(nombre.substr(index + 1,3)) - 1;
    if (nombre.indexOf("EFXP_TPO_DOC_REF") != -1) {
        arrReferencias[i][0] = obj.value;
    } else if (nombre.indexOf("EFXP_IND_GLOBAL") != -1) {
        arrReferencias[i][1] = obj.value;
    } else if (nombre.indexOf("EFXP_FOLIO_REF") != -1) {
        arrReferencias[i][2] = obj.value;
    } else if (nombre.indexOf("EFXP_CODIGO_REF") != -1) {
        arrReferencias[i][4] = obj.value;
    } else if (nombre.indexOf("EFXP_RAZON_REF") != -1) {
        arrReferencias[i][5] = obj.value;
    }
}

function insArrPagos(obj) {

    var nombre = new String(obj.name);
    var index = nombre.lastIndexOf('_');
    var i = parseInt(nombre.substr(index + 1,3)) - 1;
    if (nombre.indexOf("EFXP_MNT_PAGO") != -1) {
        arrPagos[i][1] = obj.value;
    } else if (nombre.indexOf("EFXP_GLOSA_PAGOS") != -1) {
        arrPagos[i][2] = obj.value;
    }
}

function varExiReferenArr() {

    var i = 0;
    var retorno = false;

    for (i=0; i < 3; i++) {
//        alert('['+arrReferencias[i][0]+'],['+arrReferencias[i][1]+'],['+arrReferencias[i][2]+'],['+arrReferencias[i][3]+'],['+arrReferencias[i][4]+']');
        if (arrReferencias[i][0].length > 0) {retorno = true; break;}
        if (arrReferencias[i][1].length > 0) {retorno = true; break;}
        if (arrReferencias[i][2].length > 0) {retorno = true; break;}
        if (arrReferencias[i][3].length > 0) {retorno = true; break;}
        if (arrReferencias[i][4].length > 0) {retorno = true; break;}
    }
    return(retorno);
}

function varExiOtroImpArr() {

    var i = 0;
    var retorno = false;

    for (i=0; i < 10; i++) {
//        alert('['+datosArray[i][0]+'],['+datosArray[i][1]+'],['+datosArray[i][2]+']');
        if (datosArray[i][7][indValue].length > 0) {retorno = true; break;}
    }
    return(retorno);
}

function varExiCodDetalleArr() {

    var i = 0;
    var retorno = false;

    for (i=0; i < 10; i++) {
//        alert('['+datosArray[i][0]+'],['+datosArray[i][1]+'],['+datosArray[i][2]+']');
        if (datosArray[i][0][indValue].length > 0) {retorno = true; break;}
        if (datosArray[i][1][indValue].length > 0) {retorno = true; break;}
    }
    return(retorno);
}

function varExiPagosArr() {

    var i = 0;
    var retorno = false;

    for (i=0; i < 3; i++) {
//        alert('['+arrPagos[i][0]+'],['+arrPagos[i][1]+'],['+arrPagos[i][2]+']');
        if (arrPagos[i][0].length > 0) {retorno = true; break;}
        if (arrPagos[i][1].length > 0) {retorno = true; break;}
        if (arrPagos[i][2].length > 0) {retorno = true; break;}
    }
    return(retorno);
}

function varExiMaderaArr() {

    var retorno = false;

    if (arrUbic[0].length > 0) {retorno = true;}
    return(retorno);
}

function printReferencias(){

  var i = 0;
  var j = 0;
  var diaSi = false;
  var mesSi = false;
  var tbl;
  var row;
  var cel;
  var output = '';
  var tempText = '';


    if (document.forms["VIEW_EFXP"].elements["REF_SI_NO"].checked == false)
	{
        RefeneciasChecked = '';
    } else if (document.forms["VIEW_EFXP"].elements["REF_SI_NO"].checked == true) {
        RefeneciasChecked = 'SiChecked';
    }
    if (document.forms["VIEW_EFXP"].elements["PAGO_SI_NO"].checked == false)
	{
        PagoChecked = '';
    } else if (document.forms["VIEW_EFXP"].elements["PAGO_SI_NO"].checked == true)
	{
        PagoChecked = 'SiChecked';
    }

    // Supestos, la info simpre esta guardadad en los arrglos de Pagos y referencias, si se modifica algo esto
    // queda reflejado ahi.
    // Si existe Pagos borrar linea
    tbl = document.getElementById('tblRefPago');
    row = document.getElementById('rowPagoTitulo');
    if (row != null) {
        i = row.rowIndex;
        tbl.deleteRow(i);
    }
    for (i=1; i<=3; i++) {
        tempText = 'rowPago_'+i;
        row = document.getElementById(tempText);
        if (row != null) {
            j = row.rowIndex;
            tbl.deleteRow(j);
        }
    }
    // Si existe Referencias  borrar linea
    row = document.getElementById('rowRefTitulo');
    if (row != null) {
        i = row.rowIndex;
        tbl.deleteRow(i);
    }
    for (i=1; i<=3; i++) {
        tempText = 'rowRef_'+i;
        row = document.getElementById(tempText);
        if (row != null) {
            j = row.rowIndex;
            tbl.deleteRow(j);
        }
    }
    // Si Referencia esta chequeado generar fila
    // Si pago esta chequedo generar fila
    if (RefeneciasChecked.length > 0) {
        //Fila de titulos
        row = tbl.insertRow(-1);
        row.id = 'rowRefTitulo';
        row.setAttribute("class","rowDet_Encabezado");

		cel = document.createElement("TH");
		cel.innerHTML = 'Tipo de documento';
		row.appendChild(cel);

		cel = document.createElement("TH");
		cel.innerHTML = 'Ind.';
		row.appendChild(cel);

		cel = document.createElement("TH");
		cel.innerHTML = 'Folio Ref.';
		row.appendChild(cel);

		cel = document.createElement("TH");
		cel.innerHTML = 'Fecha Ref.';
		row.appendChild(cel);

		cel = document.createElement("TH");
		cel.setAttribute("colspan", "2");
		cel.innerHTML = 'Razón Referencia';
		row.appendChild(cel);

        
        //Primera Fila referencia
        row = tbl.insertRow(-1);
        row.id = 'rowRef_1';

        cel = row.insertCell(0);
        cel.setAttribute("data-title","Tipo de Doc.");
        cel.innerHTML= printSelectTpoDocRef('EFXP_TPO_DOC_REF_001');

        cel = row.insertCell(1);
        cel.setAttribute("data-title","Ind.");
        cel.innerHTML= '<INPUT  maxLength=1 size=2 onChange="setFolioXIndRefGlb(this);insArrReferen(this);" name=EFXP_IND_GLOBAL_001 value="'+arrReferencias[0][1]+'" >';

        cel = row.insertCell(2);
        cel.setAttribute("data-title","Folio Ref.");
        cel.innerHTML= '<INPUT  maxLength=18 size=10 onChange=insArrReferen(this) name=EFXP_FOLIO_REF_001 value="'+arrReferencias[0][2]+'" >&nbsp;';

        cel = row.insertCell(3);
        cel.setAttribute("data-title","Fecha Ref.");
        output = '<INPUT  type=hidden maxLength=10 name=EFXP_FCH_REF_001 value="'+arrReferencias[0][3]+'" >';
        output += '<SELECT onchange=actulizaFecha(this) name=cbo_dia_boleta_ref_01> ';
        output += '<optgroup label="día"> ';

        for(i=1;i<=31;i++) {
            if (Number(arrReferencias[0][3].substr(8,4))==i) {
                output += '  <option value="'+ (i>9 ? i: '0'+i) +'" selected>'+ (i>9 ? i: '0'+i) +'</option>';
                diaSi = true;
            } else if ((Number(arrFecha[2])==i) && (diaSi == false)) {
                output += '  <option value="'+ (i>9 ? i: '0'+i) +'" selected>'+ (i>9 ? i: '0'+i) +'</option>';
            } else {
                output += '<option value="'+  (i>9 ? i: '0'+i) +'">'+  (i>9 ? i: '0'+i) +'</option>';
            }
        }
        diaSi = false;
        output += '</optgroup> ';
        output += '</SELECT>/';
        output += '<SELECT onchange=actulizaFecha(this) name=cbo_mes_boleta_ref_01> ';
        output += '<optgroup label="mes"> ';
        for(i=1;i<=12;i++) {
            if (Number(arrReferencias[0][3].substr(5,2))==i) {
                output += '<option value="'+  (i>9 ? i: '0'+i) +'" selected>'+ nombreMes(i) +'</option>';
                mesSi = true
            } else if ((Number(arrFecha[1])==i)&&(mesSi == false)) {
                output += '<option value="'+  (i>9 ? i: '0'+i) +'" selected>'+ nombreMes(i) +'</option>';
            } else {
                output += '<option value="'+  (i>9 ? i: '0'+i) +'">'+ nombreMes(i) +'</option>';
            }
        }
        mesSi = false;
        output += '</optgroup> ';
        output += '</SELECT>/';
        output += '<SELECT onchange=actulizaFecha(this) name=cbo_anio_boleta_ref_01>';
        output += '<optgroup label="año"> ';
        if (arrReferencias[0][3].length > 0) {
            output += listaAnos(Number(arrReferencias[0][3].substr(0,4)));
        } else {
            output += listaAnos(Number(arrFecha[0]));
        }
        output += '</optgroup> ';
        output += '  </SELECT>&nbsp;';
        cel.innerHTML = output;

        cel = row.insertCell(4);
        cel.setAttribute("data-title","Razón Ref");
        cel.innerHTML= '<INPUT  maxLength=90 size=19 onChange=insArrReferen(this) name=EFXP_RAZON_REF_001 value="'+arrReferencias[0][5]+'" >';


        //Segunda Fila referencia
        row = tbl.insertRow(-1);
        row.id = 'rowRef_2';

        cel = row.insertCell(0);
        cel.setAttribute("data-title","Tipo de Doc.");
        cel.innerHTML= printSelectTpoDocRef('EFXP_TPO_DOC_REF_002');

        cel = row.insertCell(1);
        cel.setAttribute("data-title","Ind.");
        cel.innerHTML= '<INPUT  maxLength=1 size=2 onChange="setFolioXIndRefGlb(this);insArrReferen(this);" name=EFXP_IND_GLOBAL_002 value="'+arrReferencias[1][1]+'" >';

        cel = row.insertCell(2);
        cel.setAttribute("data-title","Folio Ref.");
        cel.innerHTML= '<INPUT  maxLength=18 size=10 onChange=insArrReferen(this) name=EFXP_FOLIO_REF_002 value="'+arrReferencias[1][2]+'" >&nbsp;';

        cel = row.insertCell(3);
        cel.setAttribute("data-title","Fecha Ref.");
       output = '<INPUT  type=hidden maxLength=10 name=EFXP_FCH_REF_002 value="'+arrReferencias[1][3]+'" >';
        output += '<SELECT onchange=actulizaFecha(this) name=cbo_dia_boleta_ref_02> ';
        output += '<optgroup label="día"> ';

        for(i=1;i<=31;i++) {
            if (Number(arrReferencias[1][3].substr(8,4))==i) {
                output += '  <option value="'+ (i>9 ? i: '0'+i) +'" selected>'+ (i>9 ? i: '0'+i) +'</option>';
                diaSi = true;
            } else if ((Number(arrFecha[2])==i) && (diaSi == false)) {
                output += '  <option value="'+ (i>9 ? i: '0'+i) +'" selected>'+ (i>9 ? i: '0'+i) +'</option>';
            } else {
                output += '<option value="'+  (i>9 ? i: '0'+i) +'">'+  (i>9 ? i: '0'+i) +'</option>';
            }
        }
        diaSi = false;
        output += '</optgroup> ';
        output += '</SELECT>/';
        output += '<SELECT onchange=actulizaFecha(this) name=cbo_mes_boleta_ref_02> ';
        output += '<optgroup label="mes"> ';
        for(i=1;i<=12;i++) {
            if (Number(arrReferencias[1][3].substr(5,2))==i) {
                output += '<option value="'+  (i>9 ? i: '0'+i) +'" selected>'+ nombreMes(i) +'</option>';
                mesSi = true
            } else if ((Number(arrFecha[1])==i)&&(mesSi == false)) {
                output += '<option value="'+  (i>9 ? i: '0'+i) +'" selected>'+ nombreMes(i) +'</option>';
            } else {
                output += '<option value="'+  (i>9 ? i: '0'+i) +'">'+ nombreMes(i) +'</option>';
            }
        }
        mesSi = false;
        output += '</optgroup> ';
        output += '</SELECT>/';
        output += '<SELECT onchange=actulizaFecha(this) name=cbo_anio_boleta_ref_02>';
        output += '<optgroup label="año"> ';
        if (arrReferencias[1][3].length > 0) {
            output += listaAnos(Number(arrReferencias[1][3].substr(0,4)));
        } else {
            output += listaAnos(Number(arrFecha[0]));
        }
        output += '</optgroup> ';
        output += '  </SELECT>&nbsp;';
        cel.innerHTML = output;

        cel = row.insertCell(4);
        cel.setAttribute("data-title","Razón Ref.");
        cel.innerHTML= '<INPUT  maxLength=90 size=19 onChange=insArrReferen(this) name=EFXP_RAZON_REF_002 value="'+arrReferencias[1][5]+'" >';


        //Tercera fila referencia
        row = tbl.insertRow(-1);
        row.id = 'rowRef_3';

        cel = row.insertCell(0);
        cel.setAttribute("data-title","Tipo de Doc.");
        cel.innerHTML= printSelectTpoDocRef('EFXP_TPO_DOC_REF_003');

        cel = row.insertCell(1);
        cel.setAttribute("data-title","Ind.");
        cel.innerHTML= '<INPUT  maxLength=1 size=2 onChange="setFolioXIndRefGlb(this);insArrReferen(this);" name=EFXP_IND_GLOBAL_003 value="'+arrReferencias[2][1]+'" >';

        cel = row.insertCell(2);
        cel.setAttribute("data-title","Folio Ref.");
        cel.innerHTML= '<INPUT  maxLength=18 size=10 onChange=insArrReferen(this) name=EFXP_FOLIO_REF_003 value="'+arrReferencias[2][2]+'" >&nbsp;';

        cel = row.insertCell(3);
        cel.setAttribute("data-title","Fecha Ref.");
        output = '<INPUT  type=hidden maxLength=10 name=EFXP_FCH_REF_003 value="'+arrReferencias[2][3]+'" >';
        output += '<SELECT onchange=actulizaFecha(this) name=cbo_dia_boleta_ref_03> ';
        output += '<optgroup label="día"> ';

        for(i=1;i<=31;i++) {
            if (Number(arrReferencias[2][3].substr(8,4))==i) {
                output += '  <option value="'+ (i>9 ? i: '0'+i) +'" selected>'+ (i>9 ? i: '0'+i) +'</option>';
                diaSi = true;
            } else if ((Number(arrFecha[2])==i) && (diaSi == false)) {
                output += '  <option value="'+ (i>9 ? i: '0'+i) +'" selected>'+ (i>9 ? i: '0'+i) +'</option>';
            } else {
                output += '<option value="'+  (i>9 ? i: '0'+i) +'">'+  (i>9 ? i: '0'+i) +'</option>';
            }
        }
        diaSi = false;
        output += '</optgroup> ';
        output += '</SELECT>/';
        output += '<SELECT onchange=actulizaFecha(this) name=cbo_mes_boleta_ref_03> ';
        output += '<optgroup label="mes"> ';
        for(i=1;i<=12;i++) {
            if (Number(arrReferencias[2][3].substr(5,2))==i) {
                output += '<option value="'+  (i>9 ? i: '0'+i) +'" selected>'+ nombreMes(i) +'</option>';
                mesSi = true
            } else if ((Number(arrFecha[1])==i)&&(mesSi == false)) {
                output += '<option value="'+  (i>9 ? i: '0'+i) +'" selected>'+ nombreMes(i) +'</option>';
            } else {
                output += '<option value="'+  (i>9 ? i: '0'+i) +'">'+ nombreMes(i) +'</option>';
            }
        }
        mesSi = false;
        output += '</optgroup> ';
        output += '</SELECT>/';
        output += '<SELECT onchange=actulizaFecha(this) name=cbo_anio_boleta_ref_03>';
        output += '<optgroup label="año"> ';
        if (arrReferencias[2][3].length > 0) {
            output += listaAnos(Number(arrReferencias[2][3].substr(0,4)));
        } else {
            output += listaAnos(Number(arrFecha[0]));
        }
        output += '</optgroup> ';
        output += '  </SELECT>&nbsp;';
        cel.innerHTML = output;

        var cel = row.insertCell(4);
        cel.setAttribute("data-title","Razón Ref.");
        cel.innerHTML= '<INPUT  maxLength=90 size=19 onChange=insArrReferen(this) name=EFXP_RAZON_REF_003 value="'+arrReferencias[2][5]+'" >';
    }
        if (PagoChecked.length > 0) {

            //Fila de titulos
            row = tbl.insertRow(-1);
            row.id = 'rowPagoTitulo';
            row.setAttribute("class","rowDet_Encabezado");

    		cel = document.createElement("TH");
            cel.colSpan = 2;
            cel.innerHTML= 'Fecha de Pago';
    		row.appendChild(cel);

    		cel = document.createElement("TH");
            cel.innerHTML= 'Monto de Pago';
    		row.appendChild(cel);

    		cel = document.createElement("TH");
            cel.colSpan = 3;
            cel.innerHTML= 'Glosa de Pago';
    		row.appendChild(cel);

            //Primera Fila de Pagos
            row = tbl.insertRow(-1);
            row.id = 'rowPago_1';
            cel = row.insertCell(0);
            cel.colSpan = 2;
            cel.setAttribute("data-title","Fecha de Pago");
            output = '<INPUT  type=hidden maxLength=10 name=EFXP_FCH_PAGO_001 value="'+arrPagos[0][0]+'" >';
            output += '<SELECT onchange=actulizaFecha(this) name=cbo_dia_boleta_pago_01> ';
            output += '<optgroup label="día"> ';
            for(i=1;i<=31;i++) {
                if (Number(arrPagos[0][0].substr(8,4))==i) {
                    output += '<option value="'+ (i>9 ? i: '0'+i) +'" selected>'+ (i>9 ? i: '0'+i) +'</option>';
                    diaSi = true;
                } else if ((Number(arrFecha[2])==i) && (diaSi == false)) {
                    output += '<option value="'+ (i>9 ? i: '0'+i) +'" selected>'+ (i>9 ? i: '0'+i) +'</option>';
                } else {
                    output += '<option value="'+  (i>9 ? i: '0'+i) +'">'+  (i>9 ? i: '0'+i) +'</option>';
                }
            }
            output += '</optgroup> ';
            diaSi = false;
            output += '</SELECT>/';
            output += '<SELECT onchange=actulizaFecha(this) name=cbo_mes_boleta_pago_01> ';
            output += '<optgroup label="mes"> ';
            for(i=1;i<=12;i++) {
                if (Number(arrPagos[0][0].substr(5,2))==i) {
                    output += '<option value="'+  (i>9 ? i: '0'+i) +'" selected>'+ nombreMes(i) +'</option>';
                    mesSi = true
                } else if ((Number(arrFecha[1])==i)&&(mesSi == false)) {
                    output += '<option value="'+  (i>9 ? i: '0'+i) +'" selected>'+ nombreMes(i) +'</option>';
                } else {
                    output += '<option value="'+  (i>9 ? i: '0'+i) +'">'+ nombreMes(i) +'</option>';
                }
            }
            mesSi = false
            output += '</SELECT>/';
            output += '<SELECT onchange=actulizaFecha(this) name=cbo_anio_boleta_pago_01>';
            output += '<optgroup label="año"> ';
            if (arrPagos[0][0].length > 0) {
                output += listaAnos(Number(arrPagos[0][0].substr(0,4)));
            } else {
                output += listaAnos(Number(arrFecha[0]));
            }
            output += '</optgroup> ';
            output += '</SELECT>&nbsp;';
            cel.innerHTML= output;

            cel = row.insertCell(1);
            cel.setAttribute("data-title","Monto de Pago");
            cel.innerHTML= '<INPUT  maxLength=18 size=10 class="form-control input-sm" onChange=insArrPagos(this) name=EFXP_MNT_PAGO_001 value="'+arrPagos[0][1]+'" >&nbsp;';

            cel = row.insertCell(2);
            cel.colSpan = 3;
            cel.setAttribute("data-title","Glosa de Pago");
            cel.innerHTML= '<INPUT  maxLength=40 size=40 class="form-control input-sm" onChange=insArrPagos(this) name=EFXP_GLOSA_PAGOS_001 value="'+arrPagos[0][2]+'" >&nbsp;';


            //Segunda Fila de Pagos
            row = tbl.insertRow(-1);
            row.id = 'rowPago_2';
            cel = row.insertCell(0);
            cel.colSpan = 2;
            cel.setAttribute("data-title","Fecha de Pago");
            output = '<INPUT  type=hidden maxLength=10 name=EFXP_FCH_PAGO_002 value="'+arrPagos[1][0]+'" >';
            output += '<SELECT onchange=actulizaFecha(this) name=cbo_dia_boleta_pago_02> ';
            output += '<optgroup label="día"> ';
            for(i=1;i<=31;i++) {
                if (Number(arrPagos[1][0].substr(8,4))==i) {
                    output += '<option value="'+ (i>9 ? i: '0'+i) +'" selected>'+ (i>9 ? i: '0'+i) +'</option>';
                    diaSi = true;
                } else if ((Number(arrFecha[2])==i) && (diaSi == false)) {
                    output += '<option value="'+ (i>9 ? i: '0'+i) +'" selected>'+ (i>9 ? i: '0'+i) +'</option>';
                } else {
                    output += '<option value="'+  (i>9 ? i: '0'+i) +'">'+  (i>9 ? i: '0'+i) +'</option>';
                }
            }
            diaSi = false;
            output += '</optgroup> ';
            output += '</SELECT>/';
            output += '<SELECT onchange=actulizaFecha(this) name=cbo_mes_boleta_pago_02> ';
            output += '<optgroup label="mes"> ';
            for(i=1;i<=12;i++) {
                if (Number(arrPagos[1][0].substr(5,2))==i) {
                    output += '<option value="'+  (i>9 ? i: '0'+i) +'" selected>'+ nombreMes(i) +'</option>';
                    mesSi = true
                } else if ((Number(arrFecha[1])==i)&&(mesSi == false)) {
                    output += '<option value="'+  (i>9 ? i: '0'+i) +'" selected>'+ nombreMes(i) +'</option>';
                } else {
                    output += '<option value="'+  (i>9 ? i: '0'+i) +'">'+ nombreMes(i) +'</option>';
                }
            }
            mesSi = false
            output += '</optgroup> ';
            output += '</SELECT>/';
            output += '<SELECT onchange=actulizaFecha(this) name=cbo_anio_boleta_pago_02>';
            output += '<optgroup label="año"> ';
            if (arrPagos[1][0].length > 0) {
                output += listaAnos(Number(arrPagos[1][0].substr(0,4)));
            } else {
                output += listaAnos(Number(arrFecha[0]));
            }
            output += '</optgroup> ';
            output += '</SELECT>&nbsp;';
            cel.innerHTML= output;

            cel = row.insertCell(1);
            cel.setAttribute("data-title","Monto de Pago");
            cel.innerHTML= '<INPUT  maxLength=18 size=10 class="form-control input-sm" onChange=insArrPagos(this) name=EFXP_MNT_PAGO_002 value="'+arrPagos[1][1]+'" >&nbsp;';

            cel = row.insertCell(2);
            cel.setAttribute("data-title","Glosa de Pago");
            cel.colSpan = 3;
            cel.innerHTML= '<INPUT  maxLength=40 size=40 class="form-control input-sm" onChange=insArrPagos(this) name=EFXP_GLOSA_PAGOS_002 value="'+arrPagos[1][2]+'" >&nbsp;';


            //Tercera Fila de Pagos
            row = tbl.insertRow(-1);
            row.id = 'rowPago_3';
            cel = row.insertCell(0);
            cel.colSpan = 2;
            cel.setAttribute("data-title","Fecha de Pago");
            output = '<INPUT  type=hidden maxLength=10 name=EFXP_FCH_PAGO_003 value="'+arrPagos[2][0]+'" >';
            output += '<SELECT onchange=actulizaFecha(this)  name=cbo_dia_boleta_pago_03> ';
            output += '<optgroup label="día"> ';
            for(i=1;i<=31;i++) {
                if (Number(arrPagos[2][0].substr(8,4))==i) {
                    output += '<option value="'+ (i>9 ? i: '0'+i) +'" selected>'+ (i>9 ? i: '0'+i) +'</option>';
                    diaSi = true;
                } else if ((Number(arrFecha[2])==i) && (diaSi == false)) {
                    output += '<option value="'+ (i>9 ? i: '0'+i) +'" selected>'+ (i>9 ? i: '0'+i) +'</option>';
                } else {
                    output += '<option value="'+  (i>9 ? i: '0'+i) +'">'+  (i>9 ? i: '0'+i) +'</option>';
                }
            }
            diaSi = false;
            output += '</optgroup> ';
            output += '</SELECT>/';
            output += '<SELECT onchange=actulizaFecha(this)  name=cbo_mes_boleta_pago_03> ';
            output += '<optgroup label="mes"> ';
            for(i=1;i<=12;i++) {
                if (Number(arrPagos[2][0].substr(5,2))==i) {
                    output += '<option value="'+  (i>9 ? i: '0'+i) +'" selected>'+ nombreMes(i) +'</option>';
                    mesSi = true
                } else if ((Number(arrFecha[1])==i)&&(mesSi == false)) {
                    output += '<option value="'+  (i>9 ? i: '0'+i) +'" selected>'+ nombreMes(i) +'</option>';
                } else {
                    output += '<option value="'+  (i>9 ? i: '0'+i) +'">'+ nombreMes(i) +'</option>';
                }
            }
            mesSi = false
            output += '</SELECT>/';
            output += '<SELECT onchange=actulizaFecha(this) name=cbo_anio_boleta_pago_03>';
            output += '<optgroup label="año"> ';
            if (arrPagos[2][0].length > 0) {
                output += listaAnos(Number(arrPagos[2][0].substr(0,4)));
            } else {
                output += listaAnos(Number(arrFecha[0]));
            }
            output += '</optgroup> ';
            output += '</SELECT>&nbsp;';
            cel.innerHTML= output;

            cel = row.insertCell(1);
            cel.innerHTML= '<INPUT  maxLength=18 size=10 class="form-control input-sm" onChange=insArrPagos(this) name=EFXP_MNT_PAGO_003 value="'+arrPagos[2][1]+'" >&nbsp;';
            cel.setAttribute("data-title","Monto de Pago");

            cel = row.insertCell(2);
            cel.setAttribute("data-title","Glosa de Pago");
            cel.colSpan = 3;
            cel.innerHTML= '<INPUT  maxLength=40 size=40 class="form-control input-sm" onChange=insArrPagos(this) name=EFXP_GLOSA_PAGOS_003 value="'+arrPagos[2][2]+'" >&nbsp;';

    } 
	tbl.rows[0].cells[0].colSpan="3";
	tbl.rows[0].cells[1].colSpan="2";
	tbl.rows[0].cells[1].align="right"
}

function printUbicacion(intento=0){

  var i = 0;
  var j = 0;
  var diaSi = false;
  var mesSi = false;
  var tbl;
  var row;
  var cel;
  var output = '';
  var tempText = '';

	if (document.forms["VIEW_EFXP"].elements["UBIC_MADERA_SI_NO"] == null) {
		return;
	}

    if (document.forms["VIEW_EFXP"].elements["UBIC_MADERA_SI_NO"].checked == false)
	{
        UbicacionChecked = '';
    } else if (document.forms["VIEW_EFXP"].elements["UBIC_MADERA_SI_NO"].checked == true) {
        UbicacionChecked = 'SiChecked';
    }

    // Si Ubicacion esta chequeado generar fila
    if (UbicacionChecked.length > 0 && intento == 0) {
        if (!confirm("Esta opción es exclusiva para empresas que necesiten informar Ubicación, Rol y Plan de Manejo")) {
			document.forms["VIEW_EFXP"].elements["UBIC_MADERA_SI_NO"].checked = false;
	        return;
		}
        
    }
    
    tbl = document.getElementById('tblUbic');
	tbl.border="0";

    for (i=1; i<=3; i++) {
        tempText = 'rowUbic_'+i;
        row = document.getElementById(tempText);
        if (row != null) {
            j = row.rowIndex;
            tbl.deleteRow(j);
        }
    }

    if (UbicacionChecked.length > 0) {
        
        //Primera Fila referencia
        row = tbl.insertRow(-1);
        row.id = 'rowUbic_1';

        cel = row.insertCell(0);
        //cel.setAttribute("data-title","Tipo de Doc.");
        cel.innerHTML= '<div class="input-group input-group-sm"> \
                            <label class="input-group-addon" for="EFXP_COMUNA_ROL_ORIGEN">Comuna Rol Predio Origen</label>' + printSelectComunaMadera() + 
                           '<input type="number" min="1" max="999999" step="1" onChange="insArrUbic(this)" class="form-control" maxlength="6" size="6" value="'+arrUbic[0]+'" name="EFXP_COMUNA_ROL_ORIGEN"> \
                        </div>'

        cel = row.insertCell(1);
        //cel.setAttribute("data-title","Ind.");
        cel.innerHTML= '<div class="input-group input-group-sm"> \
                            <label class="input-group-addon" for="EFXP_MAN_ROL_ORIGEN">Manzana Rol Origen</label> \
                            <input type="number" min="1" max="999999" step="1" onChange="insArrUbic(this)" class="form-control" maxlength="6" size="6" value="'+arrUbic[1]+'" name="EFXP_MAN_ROL_ORIGEN"> \
                        </div>'

        cel = row.insertCell(2);
        //cel.setAttribute("data-title","Folio Ref.");
        cel.innerHTML= '<div class="input-group input-group-sm"> \
                            <label class="input-group-addon" for="EFXP_PRED_ROL_ORIGEN">Predio Rol Origen</label> \
                            <input type="number" min="1" max="999999" step="1" onChange="insArrUbic(this)" class="form-control" maxlength="6" size="6" value="'+arrUbic[2]+'" name="EFXP_PRED_ROL_ORIGEN"> \
                        </div>'

        //Segunda Fila referencia
        row = tbl.insertRow(-1);
        row.id = 'rowUbic_2';

        cel = row.insertCell(0);
        //cel.setAttribute("data-title","Tipo de Doc.");
        cel.innerHTML= '<div class="input-group input-group-sm"> \
                            <label class="input-group-addon" for="EFXP_SIST_REF_GEO">Sist. Ref. Geolocalización</label> \
                            <select class="form-control" name="EFXP_SIST_REF_GEO"> \
                            <option value="1">WGS84 decimal</option> \
                            </select> \
                        </div>'

        cel = row.insertCell(1);
        //cel.setAttribute("data-title","Ind.");
        cel.innerHTML= '<div class="input-group input-group-sm"> \
                            <label class="input-group-addon" for="EFXP_LAT_ORIG_MADERA">Latitud Origen Madera</label> \
                            <input type="text" onChange="insArrUbic(this)" class="form-control" maxlength="30" size="30" value="'+arrUbic[4]+'" name="EFXP_LAT_ORIG_MADERA"> \
                        </div>'

        cel = row.insertCell(2);
        //cel.setAttribute("data-title","Folio Ref.");
        cel.innerHTML= '<div class="input-group input-group-sm"> \
                            <label class="input-group-addon" for="EFXP_LONG_ORIG_MADERA">Longitud Origen Madera</label> \
                            <input type="text" onChange="insArrUbic(this)" class="form-control" maxlength="30" size="30" value="'+arrUbic[5]+'" name="EFXP_LONG_ORIG_MADERA"> \
                        </div>'

        //Tercera fila referencia
        row = tbl.insertRow(-1);
        row.id = 'rowUbic_3';

        cel = row.insertCell(0);
        //cel.setAttribute("data-title","Tipo de Doc.");
        cel.innerHTML= '<div class="input-group input-group-sm"> \
                            <label class="input-group-addon" for="EFXP_COD_PLAN_CONAF">Código Plan de Manejo CONAF</label> \
                            <input type="number" min="1" max="9999999999" step="1" onChange="insArrUbic(this)" class="form-control" maxlength="10" size="10" value="'+arrUbic[6]+'" name="EFXP_COD_PLAN_CONAF"> \
                        </div>'

        document.getElementsByName("EFXP_COMUNA_ROL_ORIGEN_SEL")[0].value = document.getElementsByName("EFXP_COMUNA_ROL_ORIGEN")[0].value;
        if (document.getElementsByName("EFXP_COMUNA_ROL_ORIGEN_SEL")[0].selectedIndex < 0) {
        	document.getElementsByName("EFXP_COMUNA_ROL_ORIGEN_SEL")[0].value = '';
		}

    }
}

function actualizaComunaMaderaSelect(obj){
    var nombre = new String(obj.name);
    if (nombre.indexOf("EFXP_COMUNA_ROL_ORIGEN_SEL") != -1) {
        document.getElementsByName("EFXP_COMUNA_ROL_ORIGEN")[0].value = obj.value;
		arrUbic[0] = obj.value;
	}
}

function actualizaComunaMaderaInput(obj){
    var nombre = new String(obj.name);
    if (nombre.indexOf("EFXP_COMUNA_ROL_ORIGEN") != -1) {
        document.getElementsByName("EFXP_COMUNA_ROL_ORIGEN_SEL")[0].value = obj.value;
		if (document.getElementsByName("EFXP_COMUNA_ROL_ORIGEN_SEL")[0].value == "") {
			document.getElementsByName("EFXP_COMUNA_ROL_ORIGEN_SEL")[0].value = "";
		}
	}
}

function printRecptorDir(){
  var i = 0;
  var output = '';

	if (recptorDir[0][0] == "0") {
        output += '<input  class="form-control" name="EFXP_DIR_RECEP"  value="" maxlength="70" size="50" >';
    } else {  
        output += '<select class="form-control" onchange=modDir(this) name="EFXP_DIR_RECEP"  >';
        output += '<optgroup label="Seleccione una opción">';
			while (recptorDir[i][0] != "0") {
					output += '<option VALUE="'+recptorDir[i][0]+'">'+recptorDir[i][0]+'</option>\n';
					i++;
			}
			output += '</optgroup>';
			output += '</select>';
	}
	document.write(output);
}

function actulizaFecha(obj) {
	var f = obj.form;

	if ((obj.name == 'cbo_dia_boleta')  || (obj.name == 'cbo_mes_boleta')  || (obj.name == 'cbo_anio_boleta')){
			f.elements["EFXP_FCH_EMIS"].value = f.elements["cbo_anio_boleta"].value+'-'+f.elements["cbo_mes_boleta"].value+'-'+f.elements["cbo_dia_boleta"].value;

	} else if ((obj.name == 'cbo_dia_boleta_ref_01')  || (obj.name == 'cbo_mes_boleta_ref_01')  || (obj.name == 'cbo_anio_boleta_ref_01')){
			f.elements["EFXP_FCH_REF_001"].value = f.elements["cbo_anio_boleta_ref_01"].value+'-'+f.elements["cbo_mes_boleta_ref_01"].value+'-'+f.elements["cbo_dia_boleta_ref_01"].value;
			arrReferencias[0][3] = f.elements["EFXP_FCH_REF_001"].value
	} else if ((obj.name == 'cbo_dia_boleta_ref_02')  || (obj.name == 'cbo_mes_boleta_ref_02')  || (obj.name == 'cbo_anio_boleta_ref_02')){
			f.elements["EFXP_FCH_REF_002"].value = f.elements["cbo_anio_boleta_ref_02"].value+'-'+f.elements["cbo_mes_boleta_ref_02"].value+'-'+f.elements["cbo_dia_boleta_ref_02"].value;
			arrReferencias[1][3] = f.elements["EFXP_FCH_REF_002"].value
	} else if ((obj.name == 'cbo_dia_boleta_ref_03')  || (obj.name == 'cbo_mes_boleta_ref_03')  || (obj.name == 'cbo_anio_boleta_ref_03')){
			f.elements["EFXP_FCH_REF_003"].value = f.elements["cbo_anio_boleta_ref_03"].value+'-'+f.elements["cbo_mes_boleta_ref_03"].value+'-'+f.elements["cbo_dia_boleta_ref_03"].value;
			arrReferencias[2][3] = f.elements["EFXP_FCH_REF_003"].value
	} else if ((obj.name == 'cbo_dia_boleta_pago_01')  || (obj.name == 'cbo_mes_boleta_pago_01')  || (obj.name == 'cbo_anio_boleta_pago_01')){
		f.elements["EFXP_FCH_PAGO_001"].value = f.elements["cbo_anio_boleta_pago_01"].value+'-'+f.elements["cbo_mes_boleta_pago_01"].value+'-'+f.elements["cbo_dia_boleta_pago_01"].value;
		arrPagos[0][0] = f.elements["EFXP_FCH_PAGO_001"].value;
	} else if ((obj.name == 'cbo_dia_boleta_pago_02')  || (obj.name == 'cbo_mes_boleta_pago_02')  || (obj.name == 'cbo_anio_boleta_pago_02')){
		f.elements["EFXP_FCH_PAGO_002"].value = f.elements["cbo_anio_boleta_pago_02"].value+'-'+f.elements["cbo_mes_boleta_pago_02"].value+'-'+f.elements["cbo_dia_boleta_pago_02"].value;
		arrPagos[1][0] = f.elements["EFXP_FCH_PAGO_002"].value;
	} else if ((obj.name == 'cbo_dia_boleta_pago_03')  || (obj.name == 'cbo_mes_boleta_pago_03')  || (obj.name == 'cbo_anio_boleta_pago_03')){
		f.elements["EFXP_FCH_PAGO_003"].value = f.elements["cbo_anio_boleta_pago_03"].value+'-'+f.elements["cbo_mes_boleta_pago_03"].value+'-'+f.elements["cbo_dia_boleta_pago_03"].value;
		arrPagos[2][0] = f.elements["EFXP_FCH_PAGO_003"].value;
	}
}

function limpiaDatos(obj) {

	var f = obj.form;

	if (f.elements["PTDC_CODIGO"].value != 110&&f.elements["PTDC_CODIGO"].value != 111&&f.elements["PTDC_CODIGO"].value != 112) {
		f.elements["EFXP_RUT_RECEP"].value = '';
		f.elements["EFXP_DV_RECEP"].value = '';
		f.elements["EFXP_CMNA_RECEP"].value = '';
		f.elements["EFXP_CIUDAD_RECEP"].value = '';
	}
	else {
		f.elements["EDFE_TOT_BOLT"].value = '0';
		f.elements["EDFE_PTO_EMBAR"].value = '0';
		f.elements["EDFE_PTO_DESEM"].value = '0';
		f.elements["EDFE_PAIS_DEST"].value = '0';
		f.elements["EDFE_TPO_MON"].value = '0';
		f.elements["EDFE_MOD_VTA"].value = '0';
	}

	f.elements["EFXP_RZN_SOC_RECEP"].value = '';
	if(f.elements["EFXP_RUT_SOLICITA"]!=null) f.elements["EFXP_RUT_SOLICITA"].value = '';
	if(f.elements["EFXP_DV_SOLICITA"]!=null) f.elements["EFXP_DV_SOLICITA"].value = '';
	f.elements["EFXP_SUBTOTAL"].value = '';
	f.elements["EFXP_PCT_DESC"].value = '';
	f.elements["EFXP_MNT_DESC"].value = '';
	f.elements["EFXP_MNT_NETO"].value = '';
	if(f.elements["EFXP_CRED_EC"]!=null) f.elements["EFXP_CRED_EC"].value = '';

	if (f.elements["PTDC_CODIGO"].value == 33) f.elements["EFXP_IVA"].value = '';

	f.elements["EFXP_MNT_TOTAL"].value = '';

	for (var i = 0; i < datosArray.length; i++) {
		for (var ii = 0; ii < datosArray[i].length ; ii++) datosArray[i][ii][indValue] = '';
	}

	for (i = 1 ; i<= f.elements["CANT_DET"].value; i++) {
		if (i < 10) {
			if(f.elements["EFXP_COD_0"+i]!=null) f.elements["EFXP_COD_0"+i].value = '';
			if(f.elements["EFXP_TPO_COD_0"+i]!=null) f.elements["EFXP_TPO_COD_0"+i].value = '';
			f.elements["EFXP_NMB_0"+i].value = '';
			f.elements["EFXP_QTY_0"+i].value = '';
			f.elements["EFXP_UNMD_0"+i].value = '';
			f.elements["EFXP_PRC_0"+i].value = '';
			if(f.elements["EFXP_OTRO_IMP_0"+i]!=null) f.elements["EFXP_OTRO_IMP_0"+i].value = '';
			f.elements["EFXP_PCTD_0"+i].value = '';
			f.elements["EFXP_SUBT_0"+i].value = '';
			if (f.elements["DESCRIP_0"+i].checked == true) {
				f.elements["DESCRIP_0"+i].checked = false;
				dibujaTextArea(f.elements["DESCRIP_0"+i]);
			}
		}
		else {
			f.elements["EFXP_COD_10"].value = '';
			f.elements["EFXP_TPO_COD_10"].value = '';
			f.elements["EFXP_NMB_10"].value = '';
			f.elements["EFXP_QTY_10"].value = '';
			f.elements["EFXP_UNMD_10"].value = '';
			f.elements["EFXP_PRC_10"].value = '';
			f.elements["EFXP_OTRO_IMP_10"].value = '';
			f.elements["EFXP_PCTD_10"].value = '';
			f.elements["EFXP_SUBT_10"].value = '';
			if (f.elements["DESCRIP_10"].checked == true) {
				f.elements["DESCRIP_10"].checked = false;
				dibujaTextArea(f.elements["DESCRIP_10"]);
			}
		}
	}

	recptorDir     = [["0","0","0"]];
	recptoActEco   = [["0","0"]];
	arrFExpo   = ["0","0","0"];

	arrReferencias[0][0] = '';  arrReferencias[0][1] = '';  arrReferencias[0][2] = '';
	arrReferencias[0][3] = '';  arrReferencias[0][5] = '';  arrReferencias[0][5] = '';
	arrReferencias[1][0] = '';  arrReferencias[1][1] = '';  arrReferencias[1][2] = '';
	arrReferencias[1][3] = '';  arrReferencias[1][5] = '';  arrReferencias[1][5] = '';
	arrReferencias[2][0] = '';  arrReferencias[2][1] = '';  arrReferencias[2][2] = '';
	arrReferencias[2][3] = '';  arrReferencias[2][5] = '';  arrReferencias[2][5] = '';

	arrPagos[0][0] = ''; arrPagos[0][1] = ''; arrPagos[0][2] = '';
	arrPagos[1][0] = ''; arrPagos[1][1] = ''; arrPagos[1][2] = '';
	arrPagos[2][0] = ''; arrPagos[2][1] = ''; arrPagos[2][2] = '';

	document.forms["VIEW_EFXP"].elements["REF_SI_NO"].checked = false;
	document.forms["VIEW_EFXP"].elements["PAGO_SI_NO"].checked = false;
	printReferencias();
	modDir(document.forms["VIEW_EFXP"].elements["EFXP_DIR_ORIGEN"]);
}

function printIva() {
    var output = '';

    output += '<TABLE><TR>';
    output += '        <TD>&nbsp;</TD>';
    output += '        <TD>&nbsp;</TD>';
    output += '        <TD>&nbsp;</TD>';
   if (document.forms["VIEW_EFXP"].elements["PTDC_CODIGO"].value == 33) {
        output += '        <TD noWrap>Monto Neto</TD>';
   } else {
        output += '        <TD noWrap>Monto Exento</TD>';
   }
   output += '        <TD>&nbsp;</TD>';
   output += '        <TD>&nbsp;</TD>';
   output += '        <TD><INPUT style="COLOR: #666666" onfocus="blur()" maxLength=12  size=10 value="'+document.forms["VIEW_EFXP"].elements["MNT_NETO_TEMP"].value+'" name=EFXP_MNT_NETO></TD>';
   output += '      </TR>';
   if (document.forms["VIEW_EFXP"].elements["PTDC_CODIGO"].value == 33) {
        output += '      <TR>';
        output += '        <TD>&nbsp;</TD>';
        output += '        <TD>&nbsp;</TD>';
        output += '        <TD>&nbsp;</TD>';
        output += '        <TD>IVA</TD>';
        output += '        <TD align="right" noWrap>&nbsp;19&nbsp;%<INPUT type=hidden maxLength=5  size=5 value="19" name=EFXP_TASA_IVA></TD>';
        output += '        <TD align="right">Total IVA</TD>';
        output += '        <TD><INPUT style="COLOR: #666666" onfocus="blur()" maxLength=12  size=10 value="'+document.forms["VIEW_EFXP"].elements["IVA_TEMP"].value+'" name=EFXP_IVA></TD>';
        output += '</TR></TABLE>';
    }
        document.write(output);

}

function despFecEmi() {
  var i, ano;
  if (document.forms["VIEW_EFXP"]==null) return;
  var campoFechaEmision = document.forms["VIEW_EFXP"].elements["EFXP_FCH_EMIS"];

  // por si se implementa la fecha como tipo fecha (solo funciona en Chrome)
  if (campoFechaEmision.type == "date") {
	  if (campoFechaEmision==null) return;
	  
	  if (campoFechaEmision.value=="") {
		  campoFechaEmision.value = fechaActual_YYYY_MM_DD();
	  }
	  
	  return;
  }
	 
  // si no es campo tipo fecha, quiere decir que no soporta ese campo, y se debe dibujar la fecha como 3 combobox
  campoFechaEmision.type = "hidden";
  
   document.write('<table class="table table-bordered table-condensed"><tr> ' +
		             '<td class="text-nowrap input-group-sm"> <select class="input" onchange="actulizaFecha(this)" name="cbo_dia_boleta">' +
                 '<optgroup label="día">');
   for(i=1;i<=31;i++)
     if (Number(arrFecha[2])==i) {
       document.write('<option value="'+ (i>9 ? i: '0'+i) +'" selected>'+ (i>9 ? i: '0'+i) +'</option>');
     } else {
       document.write('<option value="'+  (i>9 ? i: '0'+i) +'">'+  (i>9 ? i: '0'+i) +'</option>');
     }

   document.write('</optgroup></select>/');

   document.write(' <select onchange="actulizaFecha(this)" name="cbo_mes_boleta"><optgroup label="mes">');
   for(i=1;i<=12;i++)
     if (Number(arrFecha[1])==i) {
       document.write('<option value="'+ (i>9 ? i: '0'+i) +'" selected>'+ (i>9 ? i: '0'+i) +'</option>');
     } else {
       document.write('<option value="'+  (i>9 ? i: '0'+i) +'">'+  (i>9 ? i: '0'+i) +'</option>');
     }

   document.write('</optgroup></select>/');

   document.write('<select onchange="actulizaFecha(this)" name="cbo_anio_boleta"><optgroup label="año">');

   if ((Number(arrFecha[0]) == 0) || (Number(arrFecha[0]) == NaN)) {
     ano = 2005;
   } else {
     ano = Number(arrFecha[0]);
   }
   document.write('<option value="'+(ano-3)+'">'+ (ano-3) +'</option>');
   document.write('<option value="'+(ano-2)+'">'+ (ano-2) +'</option>');
   document.write('<option value="'+(ano-1)+'">'+ (ano-1) +'</option>');
   document.write('<option value="'+ano+'" selected>'+ ano +'</option>');
   document.write('<option value="'+(ano+1)+'">'+ (ano+1) +'</option>');
   document.write('</optgroup></select></td> </tr> </table>');
}

function valNumero(elemento) {
	var pattern = /^\d+$/;

	if(!pattern.test(elemento.value)) {
		alert("Valor debe ser numérico y no puede ser decimal.");
		return;
	}

	var temp = Number(elemento.value);

	if (temp == NaN) {
		alert("Valor debe ser numérico.");
		elemento.focus();
		return;
	}
}

//**NM**
function printTipoVenta(tc)
{
	document.write('<select class="form-control"  name="EFXP_TIPOVENTA_SELECT">');
	document.write('<optgroup label="Seleccione una opción">');	
	document.write("<option value='1' selected>Del Giro</option>");
	document.write("<option value='2' >Ventas que no son del Giro (Activo Fijo y Otros)</option>");
	document.write("<option value='3' >Venta de Bienes inmuebles, 'BBRR'</option>");			
	document.write('</optgroup>');	
	document.write('</select>');
}

function printTipoCompra(tc)
{
	document.write('<select class="form-control" name="EFXP_TIPOCOMPRA_SELECT">');	
	document.write('<optgroup label="Seleccione una opción">');	
	document.write("<option value='1' "+evaluaSeleccion(tc,'1','compra')+">Del Giro</option>");	
	document.write("<option value='2' "+evaluaSeleccion(tc,'2','compra')+">Supermercados</option>");
	document.write("<option value='3' "+evaluaSeleccion(tc,'3','compra')+">Venta de Bienes inmuebles, 'BBRR'</option>");			
	document.write("<option value='4' "+evaluaSeleccion(tc,'4','compra')+">Activo Fijo</option>");
	document.write("<option value='5' "+evaluaSeleccion(tc,'5','compra')+">IVA Uso Común</option>");
	document.write("<option value='6' "+evaluaSeleccion(tc,'6','compra')+">IVA no Recuperable</option>");	
	document.write("<option value='7' "+evaluaSeleccion(tc,'7','compra')+">No Corresponde incluir</option>");				
	document.write('</optgroup>');	
	document.write('</select>');	
}

function printFormaDePago(fp)
{
  esFACT_TUR=document.getElementById('esFACT_TUR');
	document.write('<select class="form-control" name="EFXP_FMA_PAGO" onChange=evaluarFormaPago()>');
	document.write('<optgroup label="Seleccione una opción">');	
	document.write("<option value='1' "+evaluaSeleccion(fp,'1','pago')+">Contado</option>");
  if (esFACT_TUR == null || esFACT_TUR.value != 'TRUE') {
	  document.write("<option value='2' "+evaluaSeleccion(fp,'2','pago')+">Crédito</option>");
  }
	document.write("<option value='3' "+evaluaSeleccion(fp,'3','pago')+">Sin Costo</option>");
	document.write('</optgroup>');	
	document.write('</select>');
}

function printTipoDocTurista(tdt)
{
  if (tdt == null || tdt == "")
		tdt = 1;
	document.write('<select class="form-control" name="EFXP_TPO_DOC_TURISTA">');
	document.write('<optgroup label="Seleccione una opción">');	
	document.write("<option value='1' "+evaluaSeleccion(tdt,'1','tipoDocTurista')+">Pasaporte</option>");
	document.write("<option value='2' "+evaluaSeleccion(tdt,'2','tipoDocTurista')+">D.N.I</option>");
	document.write('</optgroup>');	
	document.write('</select>');
}


function evaluaSeleccion(etc,valor,elemento)
{
	
	 if(etc!=null)
	 {
		if(etc==valor)
			 return 'selected';
	 }
	 else
	 {
		 if((document.forms["VIEW_EFXP"].elements["PTDC_CODIGO"].value==33) || (document.forms["VIEW_EFXP"].elements["PTDC_CODIGO"].value==34))
		 {
			if((elemento=='venta') && (valor==0)) return 'selected';      	// venta muestra 'seleccinar' por default
			 if((elemento=='compra') && (valor==1)) return 'selected';		// compra muestra 'del giro' por default
			 if((elemento=='pago') && (valor==2)) return 'selected';		// forma de pago muestra 'crédito' por default.
			 if((elemento=='tipoDocTurista') && (valor==2)) return 'selected';		// forma de pago muestra 'crédito' por default.
		 }
	 }	
	return '';
}

function evaluarFormaPago()
{
	if ((document.forms["VIEW_EFXP"].elements["PTDC_CODIGO"].value == 33) || (document.forms["VIEW_EFXP"].elements["PTDC_CODIGO"].value == 34))
	{	
		if(document.forms["VIEW_EFXP"].elements["EFXP_FMA_PAGO"].value==2)
		{
			//document.forms["VIEW_EFXP"].elements["PAGO_SI_NO"].checked = true;
		}
		else
		{
			document.forms["VIEW_EFXP"].elements["PAGO_SI_NO"].checked = false;
		}
		printReferencias();
	}
}

function readCookie(name) {
  var nameEQ = escape(name) + "=";
  var ca = document.cookie.split(';');
  for (var i = 0; i < ca.length; i++) {
    var c = ca[i];
    while (c.charAt(0) == ' ') c = c.substring(1, c.length);
    if (c.indexOf(nameEQ) == 0) return unescape(c.substring(nameEQ.length, c.length));
  }
  return null;
}

